/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.bc.group.GroupRemoveChildMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EditUserGroups
extends ViewUser {
    private String[] groupsToJoin = new String[0];
    private String[] groupsToLeave = new String[0];
    private Collection memberGroups;
    private Collection nonMemberGroups;
    private String join;
    private String leave;
    private final GroupService groupService;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;

    public EditUserGroups(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupService groupService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.groupService = groupService;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (StringUtils.isNotBlank((String)this.getJoin())) {
            List<String> groupsToJoinList;
            List<String> list = groupsToJoinList = this.groupsToJoin != null ? Arrays.asList(this.groupsToJoin) : Collections.EMPTY_LIST;
            if (!groupsToJoinList.isEmpty()) {
                this.groupService.validateAddUserToGroup(this.getJiraServiceContext(), groupsToJoinList, this.name);
            } else {
                this.getJiraServiceContext().getErrorCollection().addErrorMessage(this.getText("admin.errors.groups.must.select.one.to.join"));
            }
        }
        if (StringUtils.isNotBlank((String)this.getLeave())) {
            List<String> groupsToLeaveList;
            List<String> list = groupsToLeaveList = this.groupsToLeave != null ? Arrays.asList(this.groupsToLeave) : Collections.EMPTY_LIST;
            if (!groupsToLeaveList.isEmpty()) {
                this.groupService.validateRemoveUserFromGroups(this.getJiraServiceContext(), groupsToLeaveList, this.name);
            } else {
                this.getJiraServiceContext().getErrorCollection().addErrorMessage(this.getText("admin.errors.groups.must.select.one.to.leave"));
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (StringUtils.isNotBlank((String)this.getJoin())) {
            List<String> groupsToJoinList = this.groupsToJoin != null ? Arrays.asList(this.groupsToJoin) : Collections.EMPTY_LIST;
            this.groupService.addUsersToGroups(this.getJiraServiceContext(), groupsToJoinList, EasyList.build((Object)this.name));
            this.nonMemberGroups = null;
        } else if (StringUtils.isNotBlank((String)this.getLeave())) {
            List<String> groupsToLeaveList = this.groupsToLeave != null ? Arrays.asList(this.groupsToLeave) : Collections.EMPTY_LIST;
            GroupRemoveChildMapper mapper = new GroupRemoveChildMapper();
            mapper.register(this.name, groupsToLeaveList);
            this.groupService.removeUsersFromGroups(this.getJiraServiceContext(), mapper);
            this.memberGroups = null;
        }
        return this.getRedirect("EditUserGroups!default.jspa?name=" + URLEncoder.encode(this.getName()));
    }

    public Collection getMemberGroups() {
        if (this.memberGroups == null && this.getUser() != null) {
            this.memberGroups = this.globalPermissionGroupAssociationUtil.getGroupNamesModifiableByCurrentUser(this.getLoggedInUser(), this.getUserGroups());
            Iterator iter = this.memberGroups.iterator();
            while (iter.hasNext()) {
                Group group = this.crowdService.getGroup((String)iter.next());
                if (group != null && this.crowdService.isUserDirectGroupMember(this.getUser(), group)) continue;
                iter.remove();
            }
        }
        return this.memberGroups;
    }

    public Collection getNonMemberGroups() {
        if (this.nonMemberGroups == null && this.getUser() != null) {
            GroupQuery query = new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
            ArrayList<String> allGroupNames = new ArrayList<String>();
            Iterator it = this.crowdService.search((Query)query).iterator();
            while (it.hasNext()) {
                allGroupNames.add((String)it.next());
            }
            this.nonMemberGroups = this.globalPermissionGroupAssociationUtil.getGroupNamesModifiableByCurrentUser(this.getLoggedInUser(), allGroupNames);
            this.nonMemberGroups.removeAll(this.getUserGroups());
        }
        return this.nonMemberGroups;
    }

    public void setGroupsToJoin(String[] groupsToJoin) {
        this.groupsToJoin = groupsToJoin;
    }

    public void setGroupsToLeave(String[] groupsToLeave) {
        this.groupsToLeave = groupsToLeave;
    }

    public String getJoin() {
        return this.join;
    }

    public void setJoin(String join) {
        this.join = join;
    }

    public String getLeave() {
        return this.leave;
    }

    public void setLeave(String leave) {
        this.leave = leave;
    }
}

