/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.user.GenericEditProfile;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.net.URLEncoder;

@WebSudoRequired
public class EditUser
extends GenericEditProfile {
    String editName;
    User user;
    private final CrowdService crowdService;
    private final UserManager userManager;

    public EditUser(CrowdService crowdService, UserManager userManager, UserPropertyManager userPropertyManager) {
        super(userPropertyManager);
        this.userManager = userManager;
        this.crowdService = crowdService;
    }

    @Override
    public void doValidation() {
        super.doValidation();
        if (!this.isRemoteUserPermittedToEditSelectedUser()) {
            this.addErrorMessage(this.getText("admin.errors.must.be.sysadmin.to.edit.sysadmin"));
        }
        if (!this.userManager.canUpdateUser(this.getEditedUser())) {
            this.addErrorMessage(this.getText("admin.errors.cannot.edit.user.directory.read.only"));
        }
    }

    public boolean isRemoteUserPermittedToEditSelectedUser() {
        return this.getEditedUser() != null && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, this.getEditedUser()));
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String superResult = super.doExecute();
        if ("success".equals(superResult)) {
            return this.getRedirect("ViewUser.jspa?name=" + URLEncoder.encode(this.editName, "UTF8"));
        }
        return superResult;
    }

    public String getEditName() {
        return this.editName;
    }

    public void setEditName(String editName) {
        this.editName = editName;
    }

    @Override
    public User getEditedUser() {
        if (this.user == null) {
            this.user = this.crowdService.getUser(this.editName);
        }
        return this.user;
    }
}

