/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.group.GroupRemoveChildMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.fields.option.GroupOption;
import com.atlassian.jira.issue.fields.option.UserOption;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class BulkEditUserGroups
extends JiraWebActionSupport {
    private String[] selectedGroupsStr;
    private List<Group> selectedGroups;
    private Set selectedGroupsUsernames;
    private String[] usersToUnassign;
    private String usersToAssignStr;
    private ArrayList usersToAssign;
    private String prunedUsersToAssign;
    private ArrayList membersList;
    private ArrayList overloadedGroups;
    private String assign;
    private String unassign;
    private Integer maxMembers;
    private final MultiUserConverter multiUserConverter;
    private final ApplicationProperties applicationProperties;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GroupService groupService;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private static final int MAX_LIST_SIZE = 20;
    private static final String OPTION_VALUE_SEPERATOR = "______";

    public BulkEditUserGroups(GroupManager groupManager, MultiUserConverter multiUserConverter, ApplicationProperties applicationProperties, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupService groupService, UserManager userManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.multiUserConverter = multiUserConverter;
        this.applicationProperties = applicationProperties;
        this.groupService = groupService;
        this.groupManager = groupManager;
        this.userManager = userManager;
    }

    public void doValidation() {
        super.doValidation();
        if (this.selectedGroupsStr == null || this.selectedGroupsStr.length == 0) {
            this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.group.selected"));
            return;
        }
        if (TextUtils.stringSet((String)this.assign)) {
            if (this.getUsersToAssign() == null || this.getUsersToAssign().isEmpty()) {
                this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.users.to.add"));
                return;
            }
            GroupService.BulkEditGroupValidationResult bulkEditGroupValidationResult = this.groupService.validateAddUsersToGroup(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), this.getUsersToAssign());
            if (!bulkEditGroupValidationResult.isSuccess()) {
                ArrayList validUsers = new ArrayList(this.getUsersToAssign());
                validUsers.removeAll(bulkEditGroupValidationResult.getInvalidChildren());
                this.prunedUsersToAssign = StringUtils.join(validUsers.iterator(), (String)", ");
            }
        } else if (TextUtils.stringSet((String)this.unassign)) {
            if (this.usersToUnassign == null || this.usersToUnassign.length <= 0) {
                this.addErrorMessage(this.getText("admin.bulkeditgroups.error.no.users.to.remove"));
                return;
            }
            this.groupService.validateRemoveUsersFromGroups(this.getJiraServiceContext(), this.getGroupRemoveUserMapper());
        }
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (TextUtils.stringSet((String)this.assign)) {
            this.groupService.addUsersToGroups(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), this.getUsersToAssign());
        } else if (TextUtils.stringSet((String)this.unassign)) {
            this.groupService.removeUsersFromGroups(this.getJiraServiceContext(), this.getGroupRemoveUserMapper());
        }
        return this.redirectToView();
    }

    public Collection<Group> getAllVisibleGroups() {
        return this.globalPermissionGroupAssociationUtil.getGroupsModifiableByCurrentUser(this.getLoggedInUser(), new ArrayList<Group>(this.groupManager.getAllGroups()));
    }

    public boolean getIsGroupSelected(Group group) {
        return this.getSelectedGroupsUserHasPermToSee() != null && this.getSelectedGroupsUserHasPermToSee().contains(group);
    }

    public Collection getMembersList() {
        if (this.membersList != null || this.getSelectedGroupsUserHasPermToSee() == null) {
            return this.membersList;
        }
        this.membersList = new ArrayList();
        this.overloadedGroups = new ArrayList();
        boolean singleGroupSelected = this.getSelectedGroupsUserHasPermToSee().size() == 1;
        GroupOption allGroupOption = new GroupOption(this.getText("admin.bulkeditgroups.all.selected.groups"));
        this.membersList.add(allGroupOption);
        for (Group group : this.getSelectedGroupsUserHasPermToSee()) {
            if (group == null) continue;
            GroupOption groupOption = new GroupOption(group);
            Collection<User> users = this.groupManager.getDirectUsersInGroup(group);
            Iterator<User> usersOfGroup = users.iterator();
            int count = 0;
            while (usersOfGroup.hasNext()) {
                User user = usersOfGroup.next();
                if (user == null) continue;
                if (++count > this.getMaxUsersDisplayedPerGroup()) {
                    this.overloadedGroups.add(group.getName());
                    break;
                }
                if (singleGroupSelected || !this.isUserInAllGroupsSelected(user)) {
                    groupOption.addChildOption(new UserOption(user));
                    continue;
                }
                allGroupOption.addChildOption(new UserOption(user));
            }
            if (groupOption.getChildOptions().isEmpty()) continue;
            this.membersList.add(groupOption);
        }
        if (allGroupOption.getChildOptions().isEmpty()) {
            this.membersList.remove(allGroupOption);
        }
        return this.membersList;
    }

    public int getAssignedUsersCount() {
        int assignedUsersCount = 0;
        for (GroupOption groupOption : this.getMembersList()) {
            assignedUsersCount += groupOption.getChildOptions().size();
        }
        return assignedUsersCount;
    }

    public int getAssignedUsersListSize() {
        return this.getListSize(this.getAssignedUsersCount() + this.getMembersList().size());
    }

    public int getListSize(int size) {
        return size < 20 ? size : 20;
    }

    public String getOptionValue(UserOption userOption) {
        if (userOption != null) {
            GroupOption parentOption = userOption.getParentOption();
            if (parentOption != null && parentOption.getGroup() != null) {
                return userOption.getName() + OPTION_VALUE_SEPERATOR + parentOption.getRawName();
            }
            return userOption.getName();
        }
        return "";
    }

    public String getUnassign() {
        return this.unassign;
    }

    public void setUnassign(String unassign) {
        this.unassign = unassign;
    }

    public String getAssign() {
        return this.assign;
    }

    public void setAssign(String assign) {
        this.assign = assign;
    }

    public String[] getSelectedGroupsStr() {
        return this.selectedGroupsStr;
    }

    public void setSelectedGroupsStr(String[] selectedGroupsStr) {
        this.selectedGroupsStr = selectedGroupsStr;
    }

    public List<Group> getSelectedGroupsUserHasPermToSee() {
        if (this.selectedGroupsStr == null) {
            return new ArrayList<Group>();
        }
        if (this.selectedGroups == null) {
            ArrayList<Group> selectedGroupsHolder = new ArrayList<Group>();
            for (int i = 0; i < this.selectedGroupsStr.length; ++i) {
                String groupName = this.selectedGroupsStr[i];
                Group group = this.groupManager.getGroup(groupName);
                if (group == null) continue;
                selectedGroupsHolder.add(group);
            }
            this.selectedGroups = this.globalPermissionGroupAssociationUtil.getGroupsModifiableByCurrentUser(this.getLoggedInUser(), selectedGroupsHolder);
        }
        return this.selectedGroups;
    }

    public void setUsersToAssignStr(String usersToAssignStr) {
        this.usersToAssignStr = usersToAssignStr;
    }

    public String getUsersToAssignStr() {
        return this.usersToAssignStr;
    }

    public Collection getUsersToAssign() {
        if (this.usersToAssign == null) {
            this.usersToAssign = (ArrayList)this.multiUserConverter.extractUserStringsFromString(this.usersToAssignStr);
        }
        return this.usersToAssign;
    }

    public String getPrunedUsersToAssign() {
        return this.prunedUsersToAssign;
    }

    public void setUsersToUnassign(String[] usersToUnassign) {
        this.usersToUnassign = usersToUnassign;
    }

    public String[] getUsersToUnassign() {
        return this.usersToUnassign;
    }

    public boolean isTooManyUsersListed() {
        return this.overloadedGroups != null && !this.overloadedGroups.isEmpty();
    }

    public int getMaxUsersDisplayedPerGroup() {
        if (this.maxMembers == null) {
            int MAX_USERS_DISPLAYED_PER_GROUP = 200;
            String maxMembersStr = this.applicationProperties.getDefaultBackedString("jira.usermanagement.maxdisplaymembers");
            if (maxMembersStr != null) {
                try {
                    this.maxMembers = Integer.valueOf(maxMembersStr.trim());
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Invalid format of 'jira.usermanagement.maxdisplaymembers' property: '" + maxMembersStr + "'. Value should be an integer. Using " + 200));
                    this.maxMembers = new Integer(200);
                }
            } else {
                this.log.debug((Object)"'jira.usermanagement.maxdisplaymembers' is missing. Using 200 instead.");
                this.maxMembers = new Integer(200);
            }
        }
        return this.maxMembers;
    }

    public String getPrettyPrintOverloadedGroups() {
        StringBuffer sb = new StringBuffer();
        int length = this.overloadedGroups.size();
        for (int i = 0; i < length; ++i) {
            sb.append(this.overloadedGroups.get(i));
            if (i == length - 2 && length > 1) {
                sb.append(" ").append(this.getText("common.words.and")).append(" ");
                continue;
            }
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private GroupRemoveChildMapper getGroupRemoveUserMapper() {
        GroupRemoveChildMapper groupRemoveChildMapper = new GroupRemoveChildMapper(Arrays.asList(this.selectedGroupsStr));
        for (int i = 0; i < this.usersToUnassign.length; ++i) {
            String username = this.extractUserName(this.usersToUnassign[i]);
            String groupname = this.extractGroupName(this.usersToUnassign[i]);
            if (groupname != null) {
                groupRemoveChildMapper.register(username, groupname);
                continue;
            }
            groupRemoveChildMapper.register(username);
        }
        return groupRemoveChildMapper;
    }

    private String extractUserName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPERATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(0, splitIndex);
        }
        return optionValue;
    }

    private String extractGroupName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPERATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(splitIndex + OPTION_VALUE_SEPERATOR.length());
        }
        return null;
    }

    private String redirectToView() {
        StringBuffer redirectUrl = new StringBuffer("BulkEditUserGroups!default.jspa?");
        Iterator<Group> groups = this.getSelectedGroupsUserHasPermToSee().iterator();
        while (groups.hasNext()) {
            Group group = groups.next();
            redirectUrl.append("selectedGroupsStr=").append(JiraUrlCodec.encode(group.getName()));
            if (!groups.hasNext()) continue;
            redirectUrl.append("&");
        }
        return this.getRedirect(redirectUrl.toString());
    }

    private boolean isUserInAllGroupsSelected(User user) {
        if (this.selectedGroupsUsernames == null) {
            this.selectedGroupsUsernames = new HashSet();
            Iterator<Group> selectedGroups = this.getSelectedGroupsUserHasPermToSee().iterator();
            if (selectedGroups.hasNext()) {
                Group group = selectedGroups.next();
                this.selectedGroupsUsernames.addAll(this.groupManager.getDirectUsersInGroup(group));
                while (selectedGroups.hasNext()) {
                    group = selectedGroups.next();
                    this.selectedGroupsUsernames.retainAll(this.groupManager.getDirectUsersInGroup(group));
                }
            }
        }
        return this.selectedGroupsUsernames.contains(user);
    }
}

