/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@WebSudoRequired
public class AddUser
extends JiraWebActionSupport {
    private String username;
    private String password;
    private String confirm;
    private String fullname;
    private String email;
    private Long directoryId;
    private boolean sendEmail = false;
    private final UserService userService;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private UserService.CreateUserValidationResult result;

    public AddUser(UserService userService, UserUtil userUtil, UserManager userManager) {
        this.userService = userService;
        this.userUtil = userUtil;
        this.userManager = userManager;
    }

    public String doDefault() {
        return "input";
    }

    protected void doValidation() {
        this.result = this.userService.validateCreateUserForAdmin(this.getLoggedInUser(), this.getUsername(), this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname(), this.getDirectoryId());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            if (this.sendEmail) {
                this.userService.createUserWithNotification(this.result);
            } else {
                this.userService.createUserNoNotification(this.result);
            }
        }
        catch (PermissionException e) {
            this.addError("username", this.getText("admin.errors.user.no.permission.to.create"));
        }
        catch (CreateException e) {
            this.addError("username", this.getText("admin.errors.user.cannot.create", e.getMessage()));
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnComplete("ViewUser.jspa?name=" + JiraUrlCodec.encode(this.username.toLowerCase()));
    }

    public boolean hasReachedUserLimit() {
        return !this.userUtil.canActivateNumberOfUsers(1);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.trim();
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = !TextUtils.stringSet((String)password) ? null : password;
    }

    public boolean hasPasswordWritableDirectory() {
        return this.userManager.hasPasswordWritableDirectory();
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = !TextUtils.stringSet((String)confirm) ? null : confirm;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public List<Directory> getDirectories() {
        return this.userManager.getWritableDirectories();
    }

    public Map<Long, Boolean> getCanDirectoryUpdatePasswordMap() {
        List<Directory> directories = this.getDirectories();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(directories.size());
        for (Directory directory : directories) {
            result.put(directory.getId(), this.userManager.canDirectoryUpdateUserPassword(directory));
        }
        return result;
    }

    public UserUtil getUserUtil() {
        return this.userUtil;
    }
}

