/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.translation;

import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewTranslations
extends AbstractManageIssueTypeOptionsAction {
    public static final String ISSUECONSTANT_ISSUETYPE = "issuetype";
    public static final String ISSUECONSTANT_PRIORITY = "priority";
    public static final String ISSUECONSTANT_RESOLUTION = "resolution";
    public static final String ISSUECONSTANT_STATUS = "status";
    public static final String ISSUECONSTANT_SUBTASK = "subTask";
    public static final String TRANSLATION_PREFIX = "jira.translation.";
    public static final String STATUS_CONSTANT_NAME = "Status";
    public static final String ISSUETYPE_CONSTANT_NAME = "Issue Type";
    public static final String RESOLUTION_CONSTANT_NAME = "Resolution";
    public static final String SUBTASK_CONSTANT_NAME = "Sub-Task";
    public static final String PRIORITY_CONSTANT_NAME = "Priority";
    private final TranslationManager translationManager;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext authenticationContext;
    private final LocaleManager localeManager;
    private String issueConstantType;
    private String issueConstantName;
    private String issueConstantTranslationPrefix;
    private String redirectPage;
    private String linkName;
    private String selectedLocale;
    private Map params = new HashMap();
    private Collection<IssueConstant> issueConstants;
    public static final String LINKNAME_ISSUETYPE = "issue types";
    public static final String LINKNAME_PRIORITY = "priorities";
    public static final String LINKNAME_RESOLUTION = "resolutions";
    public static final String LINKNAME_STATUS = "statuses";
    public static final String LINKNAME_SUBTASK = "sub-tasks";

    public ViewTranslations(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, TranslationManager translationManager, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, IssueManager issueManager, LocaleManager localeManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, issueManager);
        this.translationManager = translationManager;
        this.constantsManager = constantsManager;
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
    }

    public String doDefault() {
        if (this.getSelectedLocale() == null) {
            String currentLocale = this.getUserPreferences().getString("jira.user.locale");
            if (currentLocale == null) {
                currentLocale = this.getCurrentLocale();
            }
            if (this.getInstalledLocales().containsKey(currentLocale)) {
                this.setSelectedLocale(currentLocale);
            } else {
                String localeString = !this.getInstalledLocales().isEmpty() ? (String)this.getInstalledLocales().keySet().iterator().next() : Locale.getDefault().toString();
                this.setSelectedLocale(localeString);
            }
        }
        if (this.getErrorMessages().size() == 0) {
            this.initParamsMap();
        }
        return "success";
    }

    public void doValidation() {
        Map parameters;
        this.params = parameters = ActionContext.getParameters();
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".name";
            String issueConstantDescriptionKey = TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".desc";
            if (!parameters.containsKey(issueConstantNameKey) || !parameters.containsKey(issueConstantDescriptionKey)) continue;
            String[] values = (String[])parameters.get(issueConstantNameKey);
            String nameTranslation = values[0];
            values = (String[])parameters.get(issueConstantDescriptionKey);
            String descTranslation = values[0];
            if ((!TextUtils.stringSet((String)nameTranslation) || TextUtils.stringSet((String)descTranslation)) && (TextUtils.stringSet((String)nameTranslation) || !TextUtils.stringSet((String)descTranslation))) continue;
            this.addError(this.getNameKey(issueConstant), this.getText("admin.errors.translation.name.description.pair.must.be.provided"));
            this.log.error((Object)"A name/description translation pair must be provided.");
        }
    }

    private void initParamsMap() {
        this.params.clear();
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = this.getNameKey(issueConstant);
            String issueConstantDescriptionKey = this.getDescKey(issueConstant);
            if (!this.hasTranslatedValue(issueConstant)) continue;
            this.params.put(issueConstantNameKey, issueConstant.getNameTranslation(this.getSelectedLocale()));
            this.params.put(issueConstantDescriptionKey, issueConstant.getDescTranslation(this.getSelectedLocale()));
        }
    }

    @RequiresXsrfCheck
    public String doExecute() {
        Map parameters;
        this.params = parameters = ActionContext.getParameters();
        for (IssueConstant issueConstant : this.getIssueConstants()) {
            String issueConstantNameKey = this.getNameKey(issueConstant);
            String issueConstantDescriptionKey = this.getDescKey(issueConstant);
            if (!parameters.containsKey(issueConstantNameKey) || !parameters.containsKey(issueConstantDescriptionKey)) continue;
            String[] values = (String[])parameters.get(issueConstantNameKey);
            String nameTranslation = values[0];
            values = (String[])parameters.get(issueConstantDescriptionKey);
            String descTranslation = values[0];
            Locale locale = this.localeManager.getLocale(this.getSelectedLocale());
            if (TextUtils.stringSet((String)nameTranslation) && TextUtils.stringSet((String)descTranslation)) {
                issueConstant.setTranslation(nameTranslation, descTranslation, this.getIssueConstantTranslationPrefix(), locale);
                continue;
            }
            issueConstant.deleteTranslation(this.getIssueConstantTranslationPrefix(), locale);
        }
        return this.getRedirect("ViewTranslations!default.jspa?issueConstantType=" + this.getIssueConstantType() + "&selectedLocale=" + this.getSelectedLocale());
    }

    public String getIssueConstantName() {
        if (this.issueConstantName == null) {
            if (ISSUECONSTANT_ISSUETYPE.equals(this.getIssueConstantType())) {
                this.issueConstantName = this.getText("admin.issue.constant.issuetype");
            } else if (ISSUECONSTANT_PRIORITY.equals(this.getIssueConstantType())) {
                this.issueConstantName = this.getText("admin.issue.constant.priority");
            } else if (ISSUECONSTANT_RESOLUTION.equals(this.getIssueConstantType())) {
                this.issueConstantName = this.getText("admin.issue.constant.resolution");
            } else if (ISSUECONSTANT_STATUS.equals(this.getIssueConstantType())) {
                this.issueConstantName = this.getText("admin.issue.constant.status");
            } else if (ISSUECONSTANT_SUBTASK.equals(this.getIssueConstantType())) {
                this.issueConstantName = this.getText("admin.issue.constant.subtask");
            }
        }
        return this.issueConstantName;
    }

    public String getIssueConstantTranslationPrefix() {
        if (this.issueConstantTranslationPrefix == null) {
            if (ISSUECONSTANT_ISSUETYPE.equals(this.getIssueConstantType())) {
                this.issueConstantTranslationPrefix = "jira.translation.issuetype";
            } else if (ISSUECONSTANT_PRIORITY.equals(this.getIssueConstantType())) {
                this.issueConstantTranslationPrefix = "jira.translation.priority";
            } else if (ISSUECONSTANT_RESOLUTION.equals(this.getIssueConstantType())) {
                this.issueConstantTranslationPrefix = "jira.translation.resolution";
            } else if (ISSUECONSTANT_STATUS.equals(this.getIssueConstantType())) {
                this.issueConstantTranslationPrefix = "jira.translation.status";
            } else if (ISSUECONSTANT_SUBTASK.equals(this.getIssueConstantType())) {
                this.issueConstantTranslationPrefix = "jira.translation.issuetype";
            }
        }
        return this.issueConstantTranslationPrefix;
    }

    public String getRedirectPage() {
        if (this.redirectPage == null) {
            if (ISSUECONSTANT_ISSUETYPE.equals(this.getIssueConstantType())) {
                this.redirectPage = "ViewIssueTypes.jspa";
            } else if (ISSUECONSTANT_PRIORITY.equals(this.getIssueConstantType())) {
                this.redirectPage = "ViewPriorities.jspa";
            } else if (ISSUECONSTANT_RESOLUTION.equals(this.getIssueConstantType())) {
                this.redirectPage = "ViewResolutions.jspa";
            } else if (ISSUECONSTANT_STATUS.equals(this.getIssueConstantType())) {
                this.redirectPage = "ViewStatuses.jspa";
            } else if (ISSUECONSTANT_SUBTASK.equals(this.getIssueConstantType())) {
                this.redirectPage = "ManageSubTasks.jspa";
            }
        }
        return this.redirectPage;
    }

    public Collection<IssueConstant> getIssueConstants() {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            if (this.issueConstants != null) break block5;
                            this.issueConstants = Lists.newArrayList();
                            if (!ISSUECONSTANT_ISSUETYPE.equals(this.getIssueConstantType())) break block6;
                            for (GenericValue issueTypeGV : this.constantsManager.getIssueTypes()) {
                                IssueType issueType = this.constantsManager.getIssueTypeObject(issueTypeGV.getString("id"));
                                this.issueConstants.add(issueType);
                            }
                            break block5;
                        }
                        if (!ISSUECONSTANT_PRIORITY.equals(this.getIssueConstantType())) break block7;
                        for (Priority priority : this.constantsManager.getPriorityObjects()) {
                            this.issueConstants.add(priority);
                        }
                        break block5;
                    }
                    if (!ISSUECONSTANT_RESOLUTION.equals(this.getIssueConstantType())) break block8;
                    for (GenericValue resolutionGV : this.constantsManager.getResolutions()) {
                        Resolution resolution = this.constantsManager.getResolutionObject(resolutionGV.getString("id"));
                        this.issueConstants.add(resolution);
                    }
                    break block5;
                }
                if (!ISSUECONSTANT_STATUS.equals(this.getIssueConstantType())) break block9;
                for (GenericValue statusGV : this.constantsManager.getStatuses()) {
                    Status status = this.constantsManager.getStatusObject(statusGV.getString("id"));
                    this.issueConstants.add(status);
                }
                break block5;
            }
            if (!ISSUECONSTANT_SUBTASK.equals(this.getIssueConstantType())) break block5;
            for (GenericValue issueTypeGV : this.constantsManager.getSubTaskIssueTypes()) {
                IssueType issueType = this.constantsManager.getIssueTypeObject(issueTypeGV.getString("id"));
                this.issueConstants.add(issueType);
            }
        }
        return this.issueConstants;
    }

    public String getLinkName() {
        if (this.linkName == null) {
            if (ISSUECONSTANT_ISSUETYPE.equals(this.getIssueConstantType())) {
                this.linkName = LINKNAME_ISSUETYPE;
            } else if (ISSUECONSTANT_PRIORITY.equals(this.getIssueConstantType())) {
                this.linkName = LINKNAME_PRIORITY;
            } else if (ISSUECONSTANT_RESOLUTION.equals(this.getIssueConstantType())) {
                this.linkName = LINKNAME_RESOLUTION;
            } else if (ISSUECONSTANT_STATUS.equals(this.getIssueConstantType())) {
                this.linkName = LINKNAME_STATUS;
            } else if (ISSUECONSTANT_SUBTASK.equals(this.getIssueConstantType())) {
                this.linkName = LINKNAME_SUBTASK;
            }
        }
        return this.linkName;
    }

    public String getCurrentLocale() {
        return this.authenticationContext.getLocale().toString();
    }

    public String getSelectedLocaleDisplayName() {
        Locale selectedLocale = this.localeManager.getLocale(this.getSelectedLocale());
        return selectedLocale.getDisplayName(this.authenticationContext.getLocale());
    }

    public String getNameKey(IssueConstant issueConstant) {
        String fieldName = TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".name";
        return fieldName;
    }

    public String getDescKey(IssueConstant issueConstant) {
        String fieldName = TRANSLATION_PREFIX + this.getIssueConstantName() + "." + issueConstant.getId() + ".desc";
        return fieldName;
    }

    public String getTranslatedName(IssueConstant issueConstant) {
        Object param = this.params.get(this.getNameKey(issueConstant));
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        if (param instanceof String) {
            return (String)param;
        }
        return null;
    }

    public String getTranslatedDesc(IssueConstant issueConstant) {
        Object param = this.params.get(this.getDescKey(issueConstant));
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        if (param instanceof String) {
            return (String)param;
        }
        return null;
    }

    private boolean hasTranslatedValue(IssueConstant issueConstant) {
        return this.translationManager.hasLocaleTranslation(issueConstant, this.getSelectedLocale());
    }

    public Map getInstalledLocales() {
        return this.translationManager.getInstalledLocales();
    }

    public String getIssueConstantType() {
        return this.issueConstantType;
    }

    public void setIssueConstantType(String issueConstantType) {
        this.issueConstantType = issueConstantType;
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    public void setSelectedLocale(String selectedLocale) {
        this.selectedLocale = selectedLocale;
    }

    public String getActionType() {
        return "translate";
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

