/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.translation;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;

public class TranslationManagerImpl
implements TranslationManager {
    public static final String JIRA_ISSUETYPE_TRANSLATION_PREFIX = "jira.translation.issuetype";
    public static final String JIRA_PRIORITY_TRANSLATION_PREFIX = "jira.translation.priority";
    public static final String JIRA_RESOLUTION_TRANSLATION_PREFIX = "jira.translation.resolution";
    public static final String JIRA_STATUS_TRANSLATION_PREFIX = "jira.translation.status";
    public static final String NONE = "None";
    private final Map translationPrefixMap;
    private JiraAuthenticationContext authenticationContext;

    public TranslationManagerImpl(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.translationPrefixMap = new HashMap();
        this.translationPrefixMap.put("IssueType", JIRA_ISSUETYPE_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Priority", JIRA_PRIORITY_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Resolution", JIRA_RESOLUTION_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Status", JIRA_STATUS_TRANSLATION_PREFIX);
    }

    @Override
    public Map getInstalledLocales() {
        ListOrderedMap locales = new ListOrderedMap();
        List<Locale> installedLocales = ManagerFactory.getJiraLocaleUtils().getInstalledLocales();
        for (int i = 0; i < installedLocales.size(); ++i) {
            Locale locale = installedLocales.get(i);
            locales.put(locale.toString(), locale.getDisplayName(this.authenticationContext.getLocale()));
        }
        return locales;
    }

    @Override
    public String getTranslatedNameFromString(String translationString) {
        StringTokenizer st = new StringTokenizer(translationString, "\n");
        if (st.countTokens() == 2) {
            return (String)st.nextElement();
        }
        return null;
    }

    @Override
    public String getTranslatedDescriptionFromString(String translationString) {
        StringTokenizer st = new StringTokenizer(translationString, "\n");
        String extractedDesc = null;
        while (st.hasMoreElements()) {
            extractedDesc = (String)st.nextElement();
        }
        return extractedDesc;
    }

    @Override
    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, String locale, I18nHelper i18n) {
        String issueConstantType;
        String translationPrefix;
        PropertySet ps = issueConstant.getPropertySet();
        String translationString = ps.getString((translationPrefix = this.getTranslationPrefix(issueConstantType = issueConstant.getGenericValue().getEntityName())) + issueConstant.getId() + "." + locale);
        if (!TextUtils.stringSet((String)translationString)) {
            if (TextUtils.stringSet((String)translationPrefix)) {
                String propKey = translationPrefix + "." + this.makeNameIntoProperty(issueConstant.getName()) + "." + (name ? "name" : "desc");
                translationString = i18n == null ? this.authenticationContext.getI18nHelper().getText(propKey) : i18n.getText(propKey);
                if (translationString != null && translationString.indexOf(translationPrefix) == -1) {
                    return translationString;
                }
            }
            if (name) {
                return issueConstant.getName();
            }
            return issueConstant.getDescription();
        }
        if (name) {
            return this.getTranslatedNameFromString(translationString);
        }
        return this.getTranslatedDescriptionFromString(translationString);
    }

    @Override
    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, String locale) {
        return this.getIssueConstantTranslation(issueConstant, name, locale, null);
    }

    @Override
    public boolean hasLocaleTranslation(IssueConstant issueConstant, String locale) {
        PropertySet ps = issueConstant.getPropertySet();
        String issueConstantType = issueConstant.getGenericValue().getEntityName();
        String translationPrefix = this.getTranslationPrefix(issueConstantType);
        String translationString = ps.getString(translationPrefix + issueConstant.getId() + "." + locale);
        return TextUtils.stringSet((String)translationString);
    }

    private String makeNameIntoProperty(String issueConstantName) {
        return StringUtils.deleteWhitespace((String)issueConstantName).toLowerCase();
    }

    private String getTranslationPrefix(String issueConstantType) {
        return (String)this.translationPrefixMap.get(issueConstantType);
    }

    @Override
    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, Locale locale) {
        return this.getIssueConstantTranslation(issueConstant, name, locale.toString());
    }

    @Override
    public void setIssueConstantTranslation(IssueConstant issueConstant, String issueConstantPrefix, Locale locale, String translatedName, String translatedDesc) {
        PropertySet ps = issueConstant.getPropertySet();
        String issueConstantLocaleKey = issueConstantPrefix + issueConstant.getId() + "." + locale;
        if (TextUtils.stringSet((String)translatedName) && TextUtils.stringSet((String)translatedDesc)) {
            ps.setString(issueConstantLocaleKey, translatedName + "\n" + translatedDesc);
        }
    }

    @Override
    public void deleteIssueConstantTranslation(IssueConstant issueConstant, String issueConstantPrefix, Locale locale) {
        String issueConstantLocaleKey;
        PropertySet ps = issueConstant.getPropertySet();
        if (ps.exists(issueConstantLocaleKey = issueConstantPrefix + issueConstant.getId() + "." + locale)) {
            ps.remove(issueConstantLocaleKey);
        }
    }
}

