/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ViewStatuses
extends AbstractViewConstants {
    public static final String STATUS_ENTITY_NAME = "Status";
    private static final String NEW_STATUS_DEFAULT_ICON = "/images/icons/status_generic.gif";
    private final StatusManager statusManager;
    private final WorkflowManager workflowManager;
    private List<JiraWorkflow> allWorkflows;

    public ViewStatuses(TranslationManager translationManager, StatusManager statusManager, WorkflowManager workflowManager) {
        super(translationManager);
        this.statusManager = statusManager;
        this.workflowManager = workflowManager;
        this.setIconurl(NEW_STATUS_DEFAULT_ICON);
    }

    @Override
    protected String getConstantEntityName() {
        return STATUS_ENTITY_NAME;
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return this.getText("admin.issue.constant.status.lowercase");
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getStatus(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getStatuses();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    @RequiresXsrfCheck
    public String doAddStatus() throws Exception {
        if (!TextUtils.stringSet((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon.of.status"));
        }
        return super.doAddConstant();
    }

    public Collection<String> getAssociatedWorkflows(GenericValue statusGV) {
        List<JiraWorkflow> existingWorkflows = this.getWorkflowsIncludingDrafts();
        HashSet associatedWorkflows = Sets.newHashSet();
        for (JiraWorkflow workflow : existingWorkflows) {
            List<GenericValue> linkStatuses = workflow.getLinkedStatuses();
            if (!linkStatuses.contains(statusGV)) continue;
            associatedWorkflows.add(workflow.getName());
        }
        return associatedWorkflows;
    }

    private List<JiraWorkflow> getWorkflowsIncludingDrafts() {
        if (this.allWorkflows == null) {
            this.allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        }
        return this.allWorkflows;
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ViewStatuses.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.status";
    }

    @Override
    protected GenericValue addConstant() throws GenericEntityException {
        Status status = this.statusManager.createStatus(this.name, this.description, this.iconurl);
        return status.getGenericValue();
    }
}

