/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.purge;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.scheme.purge.AbstractSchemePurgeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.List;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemePurgeToolResultsAction
extends AbstractSchemePurgeAction {
    private ErrorCollection deletionErrors;
    private List successfullyDeletedSchemes;

    public SchemePurgeToolResultsAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
    }

    public void doValidation() {
    }

    public String doExecute() throws Exception {
        this.deletionErrors = new SimpleErrorCollection();
        this.successfullyDeletedSchemes = new ArrayList();
        for (Scheme scheme : this.getSchemeObjs()) {
            List<Project> projects = this.getSchemeManager(this.getSelectedSchemeType()).getProjects(scheme);
            if (!projects.isEmpty()) {
                this.deletionErrors.addErrorMessage(this.getText("admin.scheme.purge.result.action.reassociated.scheme", "<strong>", scheme.getName(), "</strong>"));
                continue;
            }
            this.getSchemeManager(this.getSelectedSchemeType()).deleteScheme(scheme.getId());
            this.successfullyDeletedSchemes.add(scheme);
        }
        ActionContext.getSession().remove("__selectedSchemeIdsToDelete");
        return "success";
    }

    public ErrorCollection getDeletionErrors() {
        return this.deletionErrors;
    }

    public List getSuccessfullyDeletedSchemes() {
        return this.successfullyDeletedSchemes;
    }
}

