/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.distiller;

import com.atlassian.jira.bc.scheme.distiller.SchemeDistillerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.web.action.admin.scheme.AbstractSchemeToolAction;
import java.util.Collection;
import webwork.action.ActionContext;

public abstract class AbstractMergeAction
extends AbstractSchemeToolAction {
    protected DistilledSchemeResults distilledSchemeResults;
    protected SchemeDistillerService schemeDistiller;
    public static final String DISTILLED_SCHEMES_SESSION_KEY = "__distilledSchemesKey";
    private String typeOfSchemesToDisplay;

    protected AbstractMergeAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties, SchemeDistillerService schemeDistiller) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
        this.schemeDistiller = schemeDistiller;
    }

    public DistilledSchemeResults getDistilledSchemeResults() {
        if (this.distilledSchemeResults == null) {
            Collection schemesToMerge;
            this.distilledSchemeResults = (DistilledSchemeResults)ActionContext.getSession().get(DISTILLED_SCHEMES_SESSION_KEY);
            if (this.distilledSchemeResults == null && (schemesToMerge = (Collection)ActionContext.getSession().get("__selectedSchemesKey")) != null) {
                this.distilledSchemeResults = this.schemeDistiller.distillSchemes(this.getLoggedInUser(), schemesToMerge, this);
                ActionContext.getSession().put(DISTILLED_SCHEMES_SESSION_KEY, this.distilledSchemeResults);
            }
        }
        return this.distilledSchemeResults;
    }

    public String getSchemeTypeDisplayName(String schemeType) {
        if ("NotificationScheme".equals(schemeType)) {
            return this.getText("admin.scheme.picker.notification.schemes.type");
        }
        if ("PermissionScheme".equals(schemeType)) {
            return this.getText("admin.scheme.picker.permission.schemes.type");
        }
        return "";
    }

    public String getTypeOfSchemesToDisplay() {
        return this.typeOfSchemesToDisplay;
    }

    public void setTypeOfSchemesToDisplay(String typeOfSchemesToDisplay) {
        this.typeOfSchemesToDisplay = typeOfSchemesToDisplay;
    }

    public int getNumberOfSelectedSchemes() {
        int count = 0;
        for (DistilledSchemeResult distilledSchemeResult : this.getDistilledSchemeResults().getDistilledSchemeResults()) {
            if (!distilledSchemeResult.isSelected()) continue;
            ++count;
        }
        return count;
    }
}

