/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.comparison;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.scheme.distiller.SchemeDistiller;
import com.atlassian.jira.scheme.distiller.SchemeRelationships;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.web.action.admin.scheme.AbstractSchemeToolAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@WebSudoRequired
public class SchemeComparisonToolAction
extends AbstractSchemeToolAction {
    public static final String SCHEME_TOOL_NAME = "SchemeComparisonTool";
    private SchemeDistiller schemeDistiller;
    private DistilledSchemeResults distilledSchemeResults;

    public SchemeComparisonToolAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, SchemeDistiller schemeDistiller, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
        this.schemeDistiller = schemeDistiller;
    }

    public String doDefault() throws Exception {
        this.getDistilledSchemeResults();
        return "input";
    }

    public DistilledSchemeResults getDistilledSchemeResults() {
        List schemesToCompare;
        if (this.distilledSchemeResults == null && (schemesToCompare = this.getSchemeObjs()) != null) {
            this.distilledSchemeResults = this.schemeDistiller.distillSchemes(schemesToCompare);
        }
        return this.distilledSchemeResults;
    }

    public SchemeRelationships getSchemeRelationships() {
        return this.schemeDistiller.getSchemeRelationships(this.getDistilledSchemeResults());
    }

    public int getSchemeDifferencePercentage() {
        return (int)(this.getSchemeRelationships().getSchemeDifferencePercentage() * 100.0);
    }

    public String getSchemeComparisonDifference() {
        String differenceString = NumberFormat.getPercentInstance().format(this.getSchemeRelationships().getSchemeDifferencePercentage());
        if (this.getSchemeRelationships().getSchemeDifferencePercentage() == 0.0) {
            differenceString = differenceString + " (" + this.getText("admin.scheme.picker.comparison.identical") + ")";
        }
        return differenceString;
    }

    public List getSchemeEntitiesByDisplayName(Collection schemeEntities) {
        ArrayList<String> displayNames = new ArrayList<String>();
        for (SchemeEntity schemeEntity : schemeEntities) {
            displayNames.add(this.getSchemeTypeForEntity(schemeEntity));
        }
        Collections.sort(displayNames);
        return displayNames;
    }

    public int getTotalDistilledFromSchemes() {
        int i = 0;
        for (DistilledSchemeResult distilledSchemeResult : this.distilledSchemeResults.getDistilledSchemeResults()) {
            i += distilledSchemeResult.getOriginalSchemes().size();
        }
        return i;
    }

    public String getSchemeTypeForEntity(SchemeEntity schemeEntity) {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            NotificationType notificationType = ManagerFactory.getNotificationTypeManager().getNotificationType(schemeEntity.getType());
            displayName = notificationType.getDisplayName() + (schemeEntity.getParameter() == null ? "" : " (" + notificationType.getArgumentDisplay(schemeEntity.getParameter()) + ")");
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            SecurityType securityType = ManagerFactory.getPermissionTypeManager().getSecurityType(schemeEntity.getType());
            displayName = securityType.getDisplayName() + (schemeEntity.getParameter() == null ? "" : " (" + securityType.getArgumentDisplay(schemeEntity.getParameter()) + ")");
        }
        return displayName;
    }

    public String getSchemeDisplayName() {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.schemes.notifications.notifications");
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.common.words.permissions");
        }
        return displayName;
    }

    public String getComparisonToolDescription() {
        String displayName = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.scheme.comparsion.desc.1.notifications", "<br/>");
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            displayName = this.getText("admin.scheme.comparsion.desc.1.permissions", "<br/>");
        }
        return displayName;
    }

    public String getEditPage() {
        String editPage = null;
        if ("NotificationScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditNotifications";
        } else if ("PermissionScheme".equals(this.getDistilledSchemeResults().getSchemeType())) {
            editPage = "EditPermissions";
        }
        return editPage;
    }

    public String getParameters() {
        StringBuffer params = new StringBuffer();
        params.append("?selectedSchemeType=");
        params.append(this.getSelectedSchemeType());
        return params.toString();
    }

    public String getColumnWidthPercentage() {
        Collection schemes = this.getSchemeRelationships().getSchemes();
        if (schemes != null) {
            return 100 / (schemes.size() + 1) + "%";
        }
        return "100%";
    }

    @Override
    public String getToolName() {
        return SCHEME_TOOL_NAME;
    }
}

