/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.plugin.roles.ProjectRoleActorModuleDescriptor;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AbstractRoleActors
extends JiraWebActionSupport {
    protected ProjectRoleService projectRoleService;
    protected PluginAccessor pluginAccessor;
    private Long projectRoleId;

    public AbstractRoleActors(ProjectRoleService projectRoleService, PluginAccessor pluginAccessor) {
        this.projectRoleService = projectRoleService;
        this.pluginAccessor = pluginAccessor;
    }

    public Collection getRoles() {
        return this.projectRoleService.getProjectRoles(this.getLoggedInUser(), this);
    }

    public ProjectRole getProjectRole() {
        return this.projectRoleService.getProjectRole(this.getLoggedInUser(), this.projectRoleId, this);
    }

    public void setProjectRoleId(Long projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public void setId(Long projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public Long getProjectRoleId() {
        return this.projectRoleId;
    }

    public List getRoleActorTypes() {
        ArrayList<ProjectRoleActorModuleDescriptor> roleActorTypes = new ArrayList<ProjectRoleActorModuleDescriptor>();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectRoleActorModuleDescriptor.class);
        for (ProjectRoleActorModuleDescriptor projectRoleModuleDescriptor : descriptors) {
            roleActorTypes.add(projectRoleModuleDescriptor);
        }
        return roleActorTypes;
    }

    public String getConfigurationUrl(String roleActorType) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectRoleActorModuleDescriptor.class);
        for (ProjectRoleActorModuleDescriptor projectRoleModuleDescriptor : descriptors) {
            String type = projectRoleModuleDescriptor.getType();
            if (!type.equals(roleActorType)) continue;
            return projectRoleModuleDescriptor.getConfigurationUrl();
        }
        return null;
    }

    public int getTableWidthForRoleActorTypes(int percentToDivide) {
        int size = this.getRoleActorTypes().size();
        if (size > 0) {
            return percentToDivide / size;
        }
        return percentToDivide;
    }
}

