/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ViewIssueTypes
extends AbstractViewConstants {
    public static final String NEW_ISSUE_TYPE_DEFAULT_ICON = "/images/icons/genericissue.gif";
    private String style;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeManager configSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueTypeManageableOption issueTypeManageableOption;
    private final IssueTypeManager issueTypeManager;

    public ViewIssueTypes(FieldManager fieldManager, FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, TranslationManager translationManager, IssueTypeManageableOption issueTypeManageableOption, IssueTypeManager issueTypeManager) {
        super(translationManager);
        this.fieldManager = fieldManager;
        this.configSchemeManager = configSchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueTypeManageableOption = issueTypeManageableOption;
        this.issueTypeManager = issueTypeManager;
        this.setIconurl(NEW_ISSUE_TYPE_DEFAULT_ICON);
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getAllIssueTypes();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
        this.fieldManager.refresh();
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getIssueType(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssues.jspa";
    }

    public String doAddIssueType() throws Exception {
        this.getConstantsManager().validateCreateIssueType(this.getName(), this.getStyle(), this.getDescription(), this.getIconurl(), this, "name");
        if (this.hasAnyErrors()) {
            return "error";
        }
        if ("jira_subtask".equals(this.getStyle())) {
            this.issueTypeManager.createSubTaskIssueType(this.getName(), this.getDescription(), this.getIconurl());
        } else {
            this.issueTypeManager.createIssueType(this.name, this.description, this.iconurl);
        }
        return this.redirectToView();
    }

    @Override
    protected GenericValue addConstant() throws GenericEntityException {
        throw new UnsupportedOperationException("Use doAddIssueType command instead!");
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ViewIssueTypes.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.issue.type";
    }

    public ManageableOptionType getManageableOption() {
        return this.issueTypeManageableOption;
    }

    public String getActionType() {
        return "view";
    }

    public Collection getAllRelatedSchemes(String id) {
        return this.issueTypeSchemeManager.getAllRelatedSchemes(id);
    }

    public List getSchemes() {
        return this.configSchemeManager.getConfigSchemesForField(this.fieldManager.getIssueTypeField());
    }

    public FieldConfigScheme getDefaultScheme() {
        return this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

