/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.web.action.admin.issuesecurity.SchemeAwareIssueSecurityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteIssueSecurity
extends SchemeAwareIssueSecurityAction {
    private Long id;
    private boolean confirmed = false;
    private final PermissionTypeManager permTypeManager;

    public DeleteIssueSecurity(PermissionTypeManager permTypeManager) {
        this.permTypeManager = permTypeManager;
    }

    protected void doValidation() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.issuesecurity.specify.permission.to.delete"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.issuesecurity.confirm.deletion"));
        }
    }

    protected String doExecute() throws Exception {
        this.getSchemeManager().deleteEntity(this.getId());
        ManagerFactory.getIssueSecurityLevelManager().clearUsersLevels();
        if (this.getSchemeId() == null) {
            return this.getRedirect("ViewIssueSecuritySchemes.jspa");
        }
        return this.getRedirect("EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private GenericValue getIssueSecurity() throws GenericEntityException {
        return this.getSchemeManager().getEntity(this.id);
    }

    public String getIssueSecurityDisplayName() throws GenericEntityException {
        return this.getType(this.getIssueSecurity().getString("type")).getDisplayName();
    }

    public String getIssueSecurityParameter() throws GenericEntityException {
        String param = this.getIssueSecurity().getString("parameter");
        String type = this.getIssueSecurity().getString("type");
        return this.permTypeManager.getSecurityType(type).getArgumentDisplay(param);
    }

    public String getIssueSecurityName() throws GenericEntityException {
        IssueSecurityLevelManager secur = ManagerFactory.getIssueSecurityLevelManager();
        return secur.getIssueSecurityName(this.getIssueSecurity().getLong("security"));
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }
}

