/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

@WebSudoRequired
public class ConfigureFieldScreenScheme
extends AbstractFieldScreenSchemeItemAction {
    private List addableIssueOperations;
    private final ProjectIssueTypeScreenSchemeHelper helper;
    private List<Project> projects;

    public ConfigureFieldScreenScheme(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager, ProjectIssueTypeScreenSchemeHelper helper) {
        super(fieldScreenSchemeManager, fieldScreenManager);
        this.helper = helper;
    }

    protected void doValidation() {
        this.validateId();
    }

    public String doExecute() throws Exception {
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doAddFieldScreenSchemeItem() {
        this.validateIssueOperationId();
        this.validateFieldScreenId();
        if (!this.invalidInput()) {
            FieldScreenSchemeItemImpl fieldScreenSchemeItem = new FieldScreenSchemeItemImpl(this.getFieldScreenSchemeManager(), this.getFieldScreenManager());
            if (this.getIssueOperationId() != null) {
                fieldScreenSchemeItem.setIssueOperation(IssueOperations.getIssueOperation(this.getIssueOperationId()));
            } else {
                fieldScreenSchemeItem.setIssueOperation(null);
            }
            fieldScreenSchemeItem.setFieldScreen(this.getFieldScreenManager().getFieldScreen(this.getFieldScreenId()));
            this.getFieldScreenScheme().addFieldScreenSchemeItem(fieldScreenSchemeItem);
            return this.redirectToView();
        }
        return this.getResult();
    }

    public Long getIssueOperaionId(ScreenableIssueOperation issueOperation) {
        return issueOperation.getId();
    }

    public Collection getAddableIssueOperations() {
        if (this.addableIssueOperations == null) {
            this.addableIssueOperations = new LinkedList();
            this.addableIssueOperations.add(new DefaultIssueOperation());
            this.addableIssueOperations.addAll(IssueOperations.getIssueOperations());
            for (FieldScreenSchemeItem fieldScreenSchemeItem : this.getFieldScreenScheme().getFieldScreenSchemeItems()) {
                ScreenableIssueOperation issueOperation = fieldScreenSchemeItem.getIssueOperation();
                if (issueOperation != null) {
                    this.addableIssueOperations.remove(issueOperation);
                    continue;
                }
                this.addableIssueOperations.remove(new DefaultIssueOperation());
            }
        }
        return this.addableIssueOperations;
    }

    @RequiresXsrfCheck
    public String doDeleteFieldScreenSchemeItem() {
        this.validateIssueOperationId();
        if (!this.invalidInput()) {
            this.getFieldScreenScheme().removeFieldScreenSchemeItem(this.getIssueOperation());
            return this.redirectToView();
        }
        return this.getResult();
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            this.projects = this.helper.getProjectsForFieldScreenScheme(fieldScreenScheme);
        }
        return this.projects;
    }

    private static class DefaultIssueOperation
    implements ScreenableIssueOperation {
        private String nameKey = "admin.common.words.default";
        private String description = "";

        private DefaultIssueOperation() {
        }

        @Override
        public Long getId() {
            return null;
        }

        @Override
        public String getNameKey() {
            return this.nameKey;
        }

        @Override
        public String getDescriptionKey() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IssueOperation)) {
                return false;
            }
            ScreenableIssueOperation issueOperation = (ScreenableIssueOperation)o;
            if (this.description != null ? !this.description.equals(issueOperation.getDescriptionKey()) : issueOperation.getDescriptionKey() != null) {
                return false;
            }
            if (issueOperation.getId() != null) {
                return false;
            }
            return !(this.nameKey != null ? !this.nameKey.equals(issueOperation.getNameKey()) : issueOperation.getNameKey() != null);
        }

        public int hashCode() {
            int result = 0;
            result = 29 * result + (this.nameKey != null ? this.nameKey.hashCode() : 0);
            result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}

