/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.action.screen.AddFieldToScreenUtil;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import webwork.action.ActionContext;

@WebSudoRequired
public class ConfigureFieldScreen
extends JiraWebActionSupport {
    private final FieldManager fieldManager;
    private final FieldScreenManager fieldScreenManager;
    private Long id;
    private FieldScreen fieldScreen;
    private List addableFields;
    private Collection destinationTabs;
    private Collection hlFields;
    private int tabPosition;
    private String fieldPosition;
    private String[] fieldId;
    private String tabName;
    private String newTabName;
    private String confirm;
    private static final String NEW_FIELD_POSITION_PREFIX = "newFieldPosition_";
    private static final String NEW_TAB_POSITION_PREFIX = "newTabPosition_";
    private static final String REMOVE_FILED_PREFIX = "removeField_";
    private Boolean tabsAllowed;
    private AddFieldToScreenUtil addFieldToScreenUtil;
    private final ProjectFieldScreenHelper helper;
    private List<Project> projects;

    public ConfigureFieldScreen(FieldManager fieldManager, FieldScreenManager fieldScreenManager, AddFieldToScreenUtil addFieldToScreenUtil, ProjectFieldScreenHelper helper) {
        this.fieldManager = fieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.addFieldToScreenUtil = addFieldToScreenUtil;
        this.helper = helper;
        this.hlFields = new LinkedList();
        this.tabPosition = -1;
    }

    public String doDefault() throws Exception {
        return this.doExecute();
    }

    protected String doExecute() throws Exception {
        FieldScreenTab tab;
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
            return this.getResult();
        }
        if (this.tabPosition < 0 && this.getFieldScreen() != null && !this.getFieldScreen().getTabs().isEmpty()) {
            this.tabPosition = 0;
        }
        if ((tab = this.getTab()) != null) {
            this.setTabName(tab.getName());
        }
        return this.getResult();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FieldScreen getFieldScreen() {
        if (this.fieldScreen == null && this.id != null) {
            this.fieldScreen = this.fieldScreenManager.getFieldScreen(this.id);
        }
        return this.fieldScreen;
    }

    public String getFieldName(Field field) {
        if (this.fieldManager.isCustomField(field)) {
            return field.getNameKey();
        }
        return this.getText(field.getNameKey());
    }

    public Collection getAddableFields() {
        if (this.addableFields == null) {
            this.addableFields = new LinkedList<OrderableField>(this.fieldManager.getOrderableFields());
            for (FieldScreenTab fieldScreenTab : this.getFieldScreen().getTabs()) {
                for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                    this.addableFields.remove(fieldScreenLayoutItem.getOrderableField());
                }
            }
            Iterator<FieldScreenTab> iterator = this.addableFields.iterator();
            while (iterator.hasNext()) {
                OrderableField orderableField = (OrderableField)((Object)iterator.next());
                if (!this.fieldManager.isUnscreenableField(orderableField)) continue;
                iterator.remove();
            }
            Collections.sort(this.addableFields);
        }
        return this.addableFields;
    }

    public int getControlRowSize() {
        if (this.getTab().getFieldScreenLayoutItems().isEmpty()) {
            return 2;
        }
        int rowSize = 3;
        if (this.getTab().getFieldScreenLayoutItems().size() > 1) {
            rowSize += 2;
        }
        if (this.getFieldScreen().getTabs().size() > 1) {
            ++rowSize;
        }
        return rowSize;
    }

    public int getButtonRowSize() {
        int rowSize = 2;
        if (this.getTab().getFieldScreenLayoutItems().size() > 1) {
            ++rowSize;
        }
        return rowSize;
    }

    @RequiresXsrfCheck
    public String doAddField() {
        this.addFieldToScreenUtil.setFieldScreenId(this.getFieldScreen().getId());
        this.addFieldToScreenUtil.setTabPosition(this.getTabPosition());
        this.addFieldToScreenUtil.setFieldId(this.getFieldId());
        this.addFieldToScreenUtil.setFieldPosition(this.getFieldPosition());
        this.addErrorCollection(this.addFieldToScreenUtil.validate());
        if (!this.invalidInput()) {
            this.addFieldToScreenUtil.execute();
            this.hlFields.addAll(this.addFieldToScreenUtil.getHlFields());
            return this.redirectToView();
        }
        return this.getResult();
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public FieldScreenTab getTab() {
        if (this.getTabPosition() > -1) {
            return this.getFieldScreen().getTab(this.getTabPosition());
        }
        return null;
    }

    public void setTabPosition(int tabPosition) {
        this.tabPosition = tabPosition;
    }

    public String[] getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String[] fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldPosition() {
        return this.fieldPosition;
    }

    public void setFieldPosition(String fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    public String doMoveLayoutItemFirst() {
        int fieldPosition = Integer.parseInt(this.getFieldPosition());
        this.populateHlField(fieldPosition);
        FieldScreenTab fieldScreenTab = this.getFieldScreen().getTab(this.getTabPosition());
        fieldScreenTab.moveFieldScreenLayoutItemFirst(fieldPosition);
        fieldScreenTab.store();
        return this.redirectToView();
    }

    public String doMoveLayoutItemUp() {
        int fieldPosition = Integer.parseInt(this.getFieldPosition());
        this.populateHlField(fieldPosition);
        FieldScreenTab fieldScreenTab = this.getFieldScreen().getTab(this.getTabPosition());
        fieldScreenTab.moveFieldScreenLayoutItemUp(fieldPosition);
        fieldScreenTab.store();
        return this.redirectToView();
    }

    public String doMoveLayoutItemDown() {
        int fieldPosition = Integer.parseInt(this.getFieldPosition());
        this.populateHlField(fieldPosition);
        FieldScreenTab fieldScreenTab = this.getFieldScreen().getTab(this.getTabPosition());
        fieldScreenTab.moveFieldScreenLayoutItemDown(fieldPosition);
        fieldScreenTab.store();
        return this.redirectToView();
    }

    public String doMoveLayoutItemLast() {
        int fieldPosition = Integer.parseInt(this.getFieldPosition());
        this.populateHlField(fieldPosition);
        FieldScreenTab fieldScreenTab = this.getFieldScreen().getTab(this.getTabPosition());
        fieldScreenTab.moveFieldScreenLayoutItemLast(fieldPosition);
        fieldScreenTab.store();
        return this.redirectToView();
    }

    private void populateHlField(int fieldPosition) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.getFieldScreen().getTab(this.getTabPosition()).getFieldScreenLayoutItems().get(fieldPosition);
        this.hlFields.add(fieldScreenLayoutItem.getFieldId());
    }

    public Collection getDestinationTabs() {
        if (this.destinationTabs == null) {
            this.destinationTabs = new LinkedList<FieldScreenTab>(this.getFieldScreen().getTabs());
            this.destinationTabs.remove(this.getTab());
        }
        return this.destinationTabs;
    }

    public String getDestinationTabBoxName(int index) {
        return NEW_TAB_POSITION_PREFIX + index;
    }

    public String getRemoveFieldBoxName(int index) {
        return REMOVE_FILED_PREFIX + index;
    }

    @RequiresXsrfCheck
    public String doAddTab() {
        if (!TextUtils.stringSet((String)this.getNewTabName())) {
            this.addError("newTabName", this.getText("admin.common.errors.validname"));
        } else {
            for (FieldScreenTab fieldScreenTab : this.getFieldScreen().getTabs()) {
                if (!this.getNewTabName().equals(fieldScreenTab.getName())) continue;
                this.addError("newTabName", this.getText("admin.errors.field.tab.already.exists"));
                break;
            }
        }
        if (!this.invalidInput()) {
            FieldScreenTab fieldScreenTab = this.getFieldScreen().addTab(this.getNewTabName());
            this.setTabPosition(fieldScreenTab.getPosition());
            return this.redirectToView();
        }
        return this.getResult();
    }

    private String redirectToView() {
        StringBuffer redirectUrl = new StringBuffer("ConfigureFieldScreen!default.jspa?id=").append(this.getId());
        if (this.getTabPosition() > -1) {
            redirectUrl.append("&tabPosition=").append(this.getTabPosition());
        }
        Iterator iterator = this.hlFields.iterator();
        while (iterator.hasNext()) {
            redirectUrl.append("&currentFields=").append((String)iterator.next());
        }
        return this.getRedirect(redirectUrl.toString());
    }

    @RequiresXsrfCheck
    public String doRenameTab() {
        if (this.getTabPosition() < 0 || this.getTabPosition() >= this.getFieldScreen().getTabs().size()) {
            this.addErrorMessage("Invalid tab position '" + this.getTabPosition() + "'");
        }
        if (!this.invalidInput()) {
            if (TextUtils.stringSet((String)this.getTabName()) && !this.getTab().getName().equals(this.getTabName())) {
                return this.renameTab();
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String doViewDeleteTab() {
        this.validateTabPosition();
        if (this.invalidInput()) {
            return this.getResult();
        }
        return "confirm";
    }

    @RequiresXsrfCheck
    public String doDeleteTab() {
        this.validateTabPosition();
        if (this.invalidInput()) {
            return this.getResult();
        }
        this.getFieldScreen().removeTab(this.getTabPosition());
        if (!this.getFieldScreen().getTabs().isEmpty()) {
            this.setTabPosition(0);
        } else {
            this.setTabPosition(-1);
        }
        return this.redirectToView();
    }

    private void validateTabPosition() {
        if (this.getTabPosition() < 0 || this.getTabPosition() >= this.getFieldScreen().getTabs().size()) {
            this.addErrorMessage("Invalid tab position '" + this.getTabPosition() + "'");
        }
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getNewPositionTextBoxName(int index) {
        FieldScreenLayoutItem fieldScreenLayoutItem = this.getTab().getFieldScreenLayoutItem(index);
        return NEW_FIELD_POSITION_PREFIX + fieldScreenLayoutItem.getFieldId();
    }

    public String getNewPositionValue(int index) {
        return this.getTextValueFromParams(this.getNewPositionTextBoxName(index));
    }

    private String getTextValueFromParams(String newPositionFieldName) {
        String[] newFieldPositionArray = (String[])ActionContext.getParameters().get(newPositionFieldName);
        if (newFieldPositionArray != null && newFieldPositionArray.length > 0) {
            return newFieldPositionArray[0];
        }
        return "";
    }

    @RequiresXsrfCheck
    public String doConfigureTab() {
        Map parameters = ActionContext.getParameters();
        if (parameters.containsKey("moveFieldsToPosition")) {
            return this.changeFieldPositions(parameters);
        }
        if (parameters.containsKey("moveFieldsToTab")) {
            return this.changeFieldTabs(parameters);
        }
        if (parameters.containsKey("deleteFieldsFromTab")) {
            return this.removeFieldsFromTab(parameters);
        }
        throw new IllegalStateException("Unknown operation.");
    }

    private String renameTab() {
        for (FieldScreenTab fieldScreenTab : this.getFieldScreen().getTabs()) {
            if (fieldScreenTab.getPosition() == this.getTabPosition() || !this.getTabName().equals(fieldScreenTab.getName())) continue;
            this.addError("tabName", this.getText("admin.errors.tab.already.exists"));
        }
        if (!this.invalidInput()) {
            FieldScreenTab fieldScreenTab = this.getFieldScreen().getTab(this.getTabPosition());
            fieldScreenTab.setName(this.getTabName());
            fieldScreenTab.store();
            return this.redirectToView();
        }
        return this.getResult();
    }

    private String removeFieldsFromTab(Map parameters) {
        TreeSet<Integer> fieldPositions = new TreeSet<Integer>((Comparator<Integer>)new ReverseComparator());
        for (String paramName : parameters.keySet()) {
            if (!paramName.startsWith(REMOVE_FILED_PREFIX) || !TextUtils.stringSet((String)this.getTextValueFromParams(paramName))) continue;
            fieldPositions.add(Integer.valueOf(paramName.substring(REMOVE_FILED_PREFIX.length())));
        }
        if (!this.invalidInput()) {
            for (Integer fieldPosition : fieldPositions) {
                this.getTab().removeFieldScreenLayoutItem(fieldPosition);
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    private String changeFieldTabs(Map parameters) {
        TreeMap<Integer, Integer> destinationTabs = new TreeMap<Integer, Integer>((Comparator<Integer>)new ReverseComparator());
        for (String paramName : parameters.keySet()) {
            if (!paramName.startsWith(NEW_TAB_POSITION_PREFIX) || !TextUtils.stringSet((String)this.getTextValueFromParams(paramName))) continue;
            Integer fieldPosition = Integer.valueOf(paramName.substring(NEW_TAB_POSITION_PREFIX.length()));
            try {
                Integer newTabPosition = Integer.valueOf(this.getTextValueFromParams(paramName));
                if (newTabPosition < 0 || newTabPosition >= this.getFieldScreen().getTabs().size()) {
                    this.addError(paramName, this.getText("admin.errors.invalid.position"));
                    continue;
                }
                destinationTabs.put(fieldPosition, newTabPosition);
            }
            catch (NumberFormatException e) {
                this.addError(paramName, this.getText("admin.errors.invalid.position"));
            }
        }
        if (!this.invalidInput()) {
            for (Integer fieldPosition : destinationTabs.keySet()) {
                Integer newTabPosition = (Integer)destinationTabs.get(fieldPosition);
                FieldScreenLayoutItem fieldScreenLayoutItem = this.getTab().removeFieldScreenLayoutItem(fieldPosition);
                this.getFieldScreen().getTab(newTabPosition).addFieldScreenLayoutItem(fieldScreenLayoutItem.getFieldId());
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    private String changeFieldPositions(Map parameters) {
        TreeMap<Integer, FieldScreenLayoutItem> fieldPositions = new TreeMap<Integer, FieldScreenLayoutItem>();
        for (String paramName : parameters.keySet()) {
            if (!paramName.startsWith(NEW_FIELD_POSITION_PREFIX) || !TextUtils.stringSet((String)this.getTextValueFromParams(paramName))) continue;
            String fieldId = paramName.substring(NEW_FIELD_POSITION_PREFIX.length());
            try {
                Integer newFieldPosition = Integer.valueOf(this.getTextValueFromParams(paramName));
                Integer newIndex = new Integer(newFieldPosition - 1);
                if (newFieldPosition <= 0 || newFieldPosition > this.getTab().getFieldScreenLayoutItems().size()) {
                    this.addError(paramName, this.getText("admin.errors.invalid.position"));
                    continue;
                }
                if (fieldPositions.containsKey(newIndex)) {
                    this.addError(paramName, this.getText("admin.errors.invalid.position"));
                    continue;
                }
                fieldPositions.put(newIndex, this.getTab().getFieldScreenLayoutItem(fieldId));
            }
            catch (NumberFormatException e) {
                this.addError(paramName, this.getText("admin.errors.invalid.position"));
            }
        }
        if (!this.invalidInput()) {
            this.getTab().moveFieldScreenLayoutItemToPosition(fieldPositions);
            Iterator<Object> iterator = fieldPositions.values().iterator();
            while (iterator.hasNext()) {
                this.populateHlField(((FieldScreenLayoutItem)iterator.next()).getPosition());
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String doMoveTabLeft() {
        this.getFieldScreen().moveFieldScreenTabLeft(this.getTabPosition());
        this.getFieldScreen().store();
        --this.tabPosition;
        return this.redirectToView();
    }

    public String doMoveTabRight() {
        this.getFieldScreen().moveFieldScreenTabRight(this.getTabPosition());
        this.getFieldScreen().store();
        ++this.tabPosition;
        return this.redirectToView();
    }

    public String getNewTabName() {
        return this.newTabName;
    }

    public void setNewTabName(String newTabName) {
        this.newTabName = newTabName;
    }

    public Collection getHlFields() {
        return this.hlFields;
    }

    public void setCurrentFields(String[] currentFields) {
        this.hlFields = Arrays.asList(currentFields);
    }

    public boolean isTabsAllowed() {
        if (this.tabsAllowed == null) {
            this.tabsAllowed = Boolean.TRUE;
        }
        return this.tabsAllowed;
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            this.projects = this.helper.getProjectsForFieldScreen(this.getFieldScreen());
        }
        return this.projects;
    }
}

