/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class FieldLayoutSchemeHelperImpl
implements FieldLayoutSchemeHelper {
    private static final Logger log = Logger.getLogger(FieldLayoutSchemeHelperImpl.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final SearchProvider searchProvider;
    private static final Function<GenericValue, Long> GV_TO_ID_TRANSFORMER = new Function<GenericValue, Long>(){

        @Override
        public Long get(GenericValue input) {
            return new Long(input.getString("id"));
        }
    };

    public FieldLayoutSchemeHelperImpl(FieldLayoutManager fieldLayoutManager, SearchProvider searchProvider) {
        this.fieldLayoutManager = Assertions.notNull("fieldLayoutManager", fieldLayoutManager);
        this.searchProvider = Assertions.notNull("searchProvider", searchProvider);
    }

    @Override
    public boolean doesChangingFieldLayoutAssociationRequireMessage(User user, FieldLayoutScheme fieldLayoutScheme, Long oldFieldLayoutId, Long newFieldLayoutId) {
        boolean messageRequired = false;
        if (!this.fieldLayoutManager.isFieldLayoutsVisiblyEquivalent(oldFieldLayoutId, newFieldLayoutId)) {
            messageRequired = this.doProjectsHaveIssues(user, fieldLayoutScheme.getProjects());
        }
        return messageRequired;
    }

    @Override
    public boolean doesChangingFieldLayoutRequireMessage(User user, EditableFieldLayout fieldLayout) {
        return this.doProjectsHaveIssues(user, this.fieldLayoutManager.getRelatedProjects(fieldLayout));
    }

    @Override
    public boolean doesChangingFieldLayoutSchemeForProjectRequireMessage(User user, Long projectId, Long oldFieldLayoutSchemeId, Long newFieldLayoutSchemeId) {
        boolean messageRequired = false;
        if (!this.fieldLayoutManager.isFieldLayoutSchemesVisiblyEquivalent(oldFieldLayoutSchemeId, newFieldLayoutSchemeId)) {
            messageRequired = this.doProjectsHaveIssues(user, Collections.singletonList(projectId));
        }
        return messageRequired;
    }

    boolean doProjectsHaveIssues(User user, Collection<GenericValue> projects) {
        List<Long> projectIds = CollectionUtil.transform(projects.iterator(), GV_TO_ID_TRANSFORMER);
        return this.doProjectsHaveIssues(user, projectIds);
    }

    private boolean doProjectsHaveIssues(User user, List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return false;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project().inNumbers(projectIds);
        return this.doesQueryHaveIssues(user, builder.buildQuery());
    }

    private boolean doesQueryHaveIssues(User user, Query query) {
        try {
            long issueCount = this.searchProvider.searchCountOverrideSecurity(query, user);
            return issueCount > 0L;
        }
        catch (SearchException e) {
            log.warn((Object)e, (Throwable)e);
            return true;
        }
    }
}

