/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.imports.project.ProjectImportService;
import com.atlassian.jira.imports.project.ProjectImportTaskContext;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;

@WebSudoRequired
public class ProjectImportSelectProject
extends JiraWebActionSupport {
    private final ProjectImportService projectImportService;
    private final TaskManager taskManager;
    private final ProjectManager projectManager;
    private BackupOverview backupOverview = null;
    private String projectKey;
    private boolean overwrite;
    private boolean noBackupOverview = false;

    public ProjectImportSelectProject(ProjectImportService projectImportService, TaskManager taskManager, ProjectManager projectManager) {
        this.projectImportService = projectImportService;
        this.taskManager = taskManager;
        this.projectManager = projectManager;
    }

    public String doDefault() throws Exception {
        if (this.getBackupOverview() == null) {
            this.addErrorMessage(this.getText("admin.project.import.select.project.no.projects"));
            this.noBackupOverview = true;
            return "error";
        }
        return super.doDefault();
    }

    public void doValidation() {
        if (this.getBackupOverview() == null) {
            this.addErrorMessage(this.getText("admin.project.import.select.project.no.projects"));
            this.noBackupOverview = true;
            return;
        }
        BackupProject selectedProject = this.getBackupOverview().getProject(this.projectKey);
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        if (this.projectManager.getProjectObjByKey(this.projectKey) == null) {
            beanFromSession.getProjectImportOptions().setOverwriteProjectDetails(true);
        } else {
            beanFromSession.getProjectImportOptions().setOverwriteProjectDetails(this.overwrite);
        }
        this.projectImportService.validateBackupProjectImportableSystemLevel(this.getJiraServiceContext(), selectedProject, this.getBackupOverview().getBackupSystemInformation());
        this.projectImportService.validateDoMapping(this.getJiraServiceContext(), beanFromSession.getProjectImportOptions(), selectedProject, beanFromSession.getBackupOverview().getBackupSystemInformation());
    }

    public String doExecute() throws Exception {
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        beanFromSession.getProjectImportOptions().setSelectedProjectKey(this.projectKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        beanFromSession.getTaskProgressInformation().setErrorCollection(errorCollection);
        BackupProject project = beanFromSession.getBackupOverview().getProject(beanFromSession.getProjectImportOptions().getSelectedProjectKey());
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.getLoggedInUser(), errorCollection);
        TaskDescriptor<MappingResult> descriptor = this.taskManager.submitTask(new MappingResultCallable(beanFromSession.getProjectImportOptions(), project, beanFromSession.getBackupOverview().getBackupSystemInformation(), serviceContext, beanFromSession), this.getText("admin.project.import.progress.task.description.map.and.validate", project.getProject().getName()), new ProjectImportTaskContext());
        beanFromSession.getTaskProgressInformation().setTaskId(descriptor.getTaskId());
        return this.getRedirect("ProjectImportMappingProgress.jspa?redirectOnComplete=ProjectImportSummary!default.jspa");
    }

    public String doErrorFromProgress() {
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        ErrorCollection errorCollection = projectImportBean.getTaskProgressInformation().getErrorCollection();
        if (errorCollection != null && errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
            projectImportBean.getTaskProgressInformation().setErrorCollection(null);
        }
        this.projectKey = projectImportBean.getProjectImportOptions().getSelectedProjectKey();
        return "error";
    }

    public BackupOverview getBackupOverview() {
        if (this.backupOverview == null) {
            this.backupOverview = ProjectImportBean.getProjectImportBeanFromSession().getBackupOverview();
        }
        return this.backupOverview;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isNoBackupOverview() {
        return this.noBackupOverview;
    }

    public String getJsonProject(BackupProject project) {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.getLoggedInUser(), new SimpleErrorCollection());
        MessageSet messageSet = this.projectImportService.validateBackupProjectImportableSystemLevel(serviceContext, project, this.getBackupOverview().getBackupSystemInformation());
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"prj_name\": \"").append(this.jsonHtmlEscape(project.getProject().getName())).append('\"');
        sb.append(", ");
        sb.append("\"prj_key\": \"").append(this.jsonHtmlEscape(project.getProject().getKey())).append('\"');
        sb.append(", ");
        sb.append("\"prj_desc\": \"").append(this.jsonHtmlEscape(project.getProject().getDescription())).append('\"');
        sb.append(", ");
        sb.append("\"prj_lead\": \"").append(this.jsonHtmlEscape(project.getProject().getLead())).append('\"');
        sb.append(", ");
        sb.append("\"prj_url\": \"").append(this.jsonHtmlEscape(project.getProject().getUrl())).append('\"');
        sb.append(", ");
        sb.append("\"prj_send\": \"").append(this.jsonHtmlEscape(project.getProject().getEmailSender())).append('\"');
        sb.append(", ");
        sb.append("\"prj_iss\": \"").append(project.getIssueIds().size()).append('\"');
        sb.append(", ");
        sb.append("\"prj_ass\": \"").append(this.jsonHtmlEscape(this.getAssigneeTypeString(project.getProject().getAssigneeType()))).append('\"');
        sb.append(", ");
        sb.append("\"prj_comp\": \"").append(project.getProjectComponents().size()).append('\"');
        sb.append(", ");
        sb.append("\"prj_ver\": \"").append(project.getProjectVersions().size()).append('\"');
        sb.append(", ");
        sb.append("\"prj_imp\": ").append(!messageSet.hasAnyErrors());
        sb.append(", ");
        sb.append("\"errors\": ").append("[").append(this.makeJsArray(messageSet.getErrorMessages())).append("]");
        sb.append(", ");
        sb.append("\"warnings\": ").append("[").append(this.makeJsArray(messageSet.getWarningMessages())).append("]");
        sb.append("}");
        return sb.toString();
    }

    private String makeJsArray(Collection<String> elements) {
        StringBuffer array = new StringBuffer();
        Iterator<String> iterator = elements.iterator();
        while (iterator.hasNext()) {
            String msg = iterator.next();
            array.append('\"').append(this.jsonHtmlEscape(msg)).append('\"');
            if (!iterator.hasNext()) continue;
            array.append(",");
        }
        return array.toString();
    }

    private String getAssigneeTypeString(String assigneeType) {
        if (String.valueOf(3L).equals(assigneeType)) {
            return this.getText("admin.assignee.type.unassigned");
        }
        if (String.valueOf(2L).equals(assigneeType)) {
            return this.getText("admin.assignee.type.project.lead");
        }
        return "";
    }

    private String jsonHtmlEscape(String str) {
        return JSONEscaper.escape(TextUtils.htmlEncode((String)str));
    }

    private class MappingResultCallable
    implements Callable<MappingResult>,
    ProvidesTaskProgress {
        private TaskProgressSink taskProgressSink;
        private final ProjectImportOptions projectImportOptions;
        private final BackupProject selectedProject;
        private final BackupSystemInformation backupSystemInformation;
        private final JiraServiceContext serviceContext;
        private final ProjectImportBean projectImportBean;

        public MappingResultCallable(ProjectImportOptions projectImportOptions, BackupProject selectedProject, BackupSystemInformation backupSystemInformation, JiraServiceContext serviceContext, ProjectImportBean projectImportBean) {
            this.projectImportOptions = projectImportOptions;
            this.selectedProject = selectedProject;
            this.backupSystemInformation = backupSystemInformation;
            this.serviceContext = serviceContext;
            this.projectImportBean = projectImportBean;
        }

        @Override
        public MappingResult call() throws Exception {
            TaskProgressInterval taskProgressInterval = new TaskProgressInterval(this.taskProgressSink, 0, 50);
            ProjectImportData projectImportData = ProjectImportSelectProject.this.projectImportService.getProjectImportData(this.serviceContext, this.projectImportOptions, this.selectedProject, this.backupSystemInformation, taskProgressInterval);
            this.projectImportBean.setProjectImportData(projectImportData);
            if (projectImportData == null) {
                return null;
            }
            taskProgressInterval = new TaskProgressInterval(this.taskProgressSink, 50, 100);
            return ProjectImportSelectProject.this.projectImportService.doMapping(this.serviceContext, this.projectImportOptions, projectImportData, this.selectedProject, this.backupSystemInformation, taskProgressInterval);
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }
    }
}

