/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.imports.project.ProjectImportService;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.imports.project.ProjectImportTaskContext;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.ProjectImportOptionsImpl;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@WebSudoRequired
public class ProjectImportSelectBackup
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger((String)"com.atlassian.jira.imports.project.web.action.ProjectImportSelectBackup");
    private final ProjectImportService projectImportService;
    private final TaskManager taskManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraHome jiraHome;
    private final AttachmentManager attachmentManager;
    private String backupXmlPath;

    public ProjectImportSelectBackup(ProjectImportService projectImportService, TaskManager taskManager, BuildUtilsInfo buildUtilsInfo, JiraHome jiraHome, AttachmentManager attachmentManager) {
        this.projectImportService = projectImportService;
        this.taskManager = taskManager;
        this.buildUtilsInfo = Assertions.notNull("buildUtilsInfo", buildUtilsInfo);
        this.jiraHome = Assertions.notNull("jiraHome", jiraHome);
        this.attachmentManager = Assertions.notNull("attachmentManager", attachmentManager);
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String doCancel() throws Exception {
        ProjectImportBean.clearFromSession();
        log.info((Object)"Project Import cancelled by the user.");
        return this.doDefault();
    }

    public void doValidation() {
        this.projectImportService.validateGetBackupOverview(this.getJiraServiceContext(), new ProjectImportOptionsImpl(this.getSafeBackupXmlFilename(), this.getDefaultImportAttachmentsPath()));
    }

    public String doExecute() throws Exception {
        ProjectImportBean.clearFromSession();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        beanFromSession.getTaskProgressInformation().setErrorCollection(errorCollection);
        beanFromSession.setProjectImportOptions(new ProjectImportOptionsImpl(this.getSafeBackupXmlFilename(), this.getDefaultImportAttachmentsPath()));
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.getLoggedInUser(), errorCollection);
        TaskDescriptor<BackupOverview> descriptor = this.taskManager.submitTask(new BackupOverviewCallable(serviceContext), this.getText("admin.project.import.progress.task.description"), new ProjectImportTaskContext());
        beanFromSession.getTaskProgressInformation().setTaskId(descriptor.getTaskId());
        return this.getRedirect("ProjectImportBackupOverviewProgress.jspa?redirectOnComplete=ProjectImportSelectProject!default.jspa");
    }

    public String doErrorFromProgress() {
        ErrorCollection errorCollection = ProjectImportBean.getProjectImportBeanFromSession().getTaskProgressInformation().getErrorCollection();
        if (errorCollection != null && errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
        }
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        this.backupXmlPath = new File(beanFromSession.getProjectImportOptions().getPathToBackupXml()).getName();
        return "error";
    }

    public String getBackupXmlPath() {
        return this.backupXmlPath;
    }

    public void setBackupXmlPath(String backupXmlPath) {
        this.backupXmlPath = backupXmlPath;
    }

    public String getDefaultImportPath() {
        return this.jiraHome.getImportDirectory().getAbsolutePath();
    }

    public String getDefaultImportAttachmentsPath() {
        if (this.attachmentManager.attachmentsEnabled()) {
            return this.jiraHome.getImportAttachmentsDirectory().getAbsolutePath();
        }
        return null;
    }

    private String getSafeBackupXmlFilename() {
        if (StringUtils.isEmpty((String)this.getBackupXmlPath())) {
            return null;
        }
        File xmlPath = new File(this.getBackupXmlPath());
        File importXmlPath = new File(this.getDefaultImportPath(), xmlPath.getName());
        try {
            return importXmlPath.getCanonicalPath();
        }
        catch (IOException e) {
            return FilenameUtils.normalize((String)importXmlPath.getAbsolutePath());
        }
    }

    public boolean isShowResumeLinkStep2() {
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        return projectImportBean.getBackupOverview() != null && !this.isShowResumeLinkStep3();
    }

    public boolean isShowResumeLinkStep3() {
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        return projectImportBean.getProjectImportData() != null;
    }

    public String getSelectedProjectName() {
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        BackupProject backupProject = projectImportBean.getSelectedProject();
        if (backupProject != null) {
            return backupProject.getProject().getName();
        }
        return null;
    }

    public String getDocsLink() {
        HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("restore_project");
        if (helpPath != null) {
            return helpPath.getUrl();
        }
        return null;
    }

    public String getVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    private class BackupOverviewCallable
    implements Callable<BackupOverview>,
    ProvidesTaskProgress {
        private TaskProgressSink taskProgressSink;
        private final JiraServiceContext serviceContext;

        public BackupOverviewCallable(JiraServiceContext serviceContext) {
            this.serviceContext = serviceContext;
        }

        @Override
        public BackupOverview call() throws Exception {
            return ProjectImportSelectBackup.this.projectImportService.getBackupOverview(this.serviceContext, new ProjectImportOptionsImpl(ProjectImportSelectBackup.this.getSafeBackupXmlFilename(), ProjectImportSelectBackup.this.getDefaultImportAttachmentsPath()), this.taskProgressSink);
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }
    }
}

