/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.dashboards.AbstractDashboardAdministration;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class ChangeSharedDashboardOwner
extends AbstractDashboardAdministration {
    private User ownerUserObj;
    private String owner;
    private String ownerError;
    private final UserPickerSearchService userPickerSearchService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final PortalPageService portalPageService;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;

    public ChangeSharedDashboardOwner(PermissionManager permissionManager, UserPickerSearchService userPickerSearchService, AvatarService avatarService, UserManager userManager, PortalPageService portalPageService, PortalPageManager portalPageManager, ShareTypeValidatorUtils shareTypeValidatorUtils) {
        super(permissionManager, portalPageManager);
        this.permissionManager = permissionManager;
        this.userPickerSearchService = userPickerSearchService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.portalPageService = portalPageService;
        this.shareTypeValidatorUtils = shareTypeValidatorUtils;
    }

    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext(this.owner);
        this.portalPageService.validateForChangeOwner(ctx, this.getDashboard());
        this.addErrorCollection(ctx.getErrorCollection());
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.portalPageService.updatePortalPageUnconditionally(ctx, this.getLoggedInUser(), this.getDashboard());
        this.addErrorCollection(this.convertAllDelegatedUserErrorsToMessages(ctx.getErrorCollection()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private ErrorCollection convertAllDelegatedUserErrorsToMessages(ErrorCollection errorCollection) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessages(errorCollection.getErrorMessages());
        String delegatedUserError = errorCollection.getErrors().get("shares_delegated");
        if (StringUtils.isNotBlank((String)delegatedUserError)) {
            errors.addErrorMessage(delegatedUserError);
        }
        return errors;
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.ownerError)) {
            this.setOwnerError(null);
        }
        if (StringUtils.isBlank((String)this.owner)) {
            this.setOwnerError("");
            this.addError("owner", this.getText("shareddashboards.admin.dashboard.owner.empty"));
        } else {
            this.validateUserExists(this.owner);
        }
        if (!this.hasAnyErrors()) {
            this.setDashboard(this.createUpdatedPortalPageForOwner(this.getDashboard(), this.owner));
            JiraServiceContext ctx = this.getJiraServiceContext(this.owner);
            this.shareTypeValidatorUtils.isValidSharePermission(ctx, this.getDashboard());
            this.addErrorCollection(this.convertAllDelegatedUserErrorsToMessages(ctx.getErrorCollection()));
        }
    }

    public boolean canChangeOwner() {
        return !this.hasAnyErrors();
    }

    public boolean userPickerDisabled() {
        return !this.userPickerSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public User getOwnerUserObj() throws Exception {
        if (this.getOwner() != null && this.ownerUserObj == null) {
            this.ownerUserObj = this.userManager.getUserObject(this.getOwner());
        }
        return this.ownerUserObj;
    }

    public String getOwner() {
        if (this.owner == null) {
            this.owner = this.getDashboard().getOwnerUserName();
        }
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    private void validateUserExists(String owner) {
        if (this.userManager.getUserObject(owner) == null) {
            this.addError("owner", String.format("The user %s does not exist", owner));
            this.setOwnerError(owner);
        }
    }

    public URI getOwnerUserAvatarUrl() {
        return this.avatarService.getAvatarUrlNoPermCheck(this.getOwner(), Avatar.Size.SMALL);
    }

    public String getOwnerError() {
        return this.ownerError;
    }

    public void setOwnerError(String ownerError) {
        this.ownerError = ownerError;
    }

    private PortalPage createUpdatedPortalPageForOwner(PortalPage dashboard, String ownerName) {
        PortalPage portalPage = this.getDashboard();
        if (portalPage != null) {
            return PortalPage.portalPage(portalPage).owner(ownerName).build();
        }
        return portalPage;
    }
}

