/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.dashboards;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractDashboardAdministration
extends JiraWebActionSupport {
    private PortalPage dashboard;
    private Long dashboardId;
    private final PermissionManager permissionManager;
    private final PortalPageManager portalPageManager;
    private String searchName;
    private String searchOwnerUserName;
    private String sortColumn;
    private String sortAscending;
    private String pagingOffset;
    private String totalResultCount;

    public AbstractDashboardAdministration(PermissionManager permissionManager, PortalPageManager portalPageManager) {
        this.permissionManager = permissionManager;
        this.portalPageManager = portalPageManager;
    }

    protected PortalPage getDashboard() {
        if (this.dashboard == null && this.getDashboardId() != null) {
            this.dashboard = this.portalPageManager.getPortalPageById(this.getDashboardId());
        }
        return this.dashboard;
    }

    protected void setDashboard(PortalPage dashboard) {
        this.dashboard = dashboard;
    }

    public Long getDashboardId() {
        return this.dashboardId;
    }

    public void setDashboardId(Long dashboardId) {
        this.dashboardId = dashboardId;
    }

    public void setPageId(Long pageId) {
        this.dashboardId = pageId;
    }

    public String getDashboardName() throws GenericEntityException {
        PortalPage dashboard = this.getDashboard();
        return dashboard == null ? null : dashboard.getName();
    }

    public String getPageName() throws Exception {
        return this.getDashboardName();
    }

    public Long getPageId() {
        return this.getDashboardId();
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getSearchOwnerUserName() {
        return this.searchOwnerUserName;
    }

    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.searchOwnerUserName = searchOwnerUserName;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public String getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(String sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getPagingOffset() {
        return this.pagingOffset;
    }

    public void setPagingOffset(String pagingOffset) {
        this.pagingOffset = pagingOffset;
    }

    public String getTotalResultCount() {
        return this.totalResultCount;
    }

    public void setTotalResultCount(String totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    protected String buildReturnUri() {
        StringBuilder url = new StringBuilder(this.getReturnUrl());
        url.append("?atl_token=").append(JiraUrlCodec.encode(this.getXsrfToken(), "UTF-8"));
        if (StringUtils.isNotBlank((String)this.getSearchName())) {
            url.append("&searchName=").append(JiraUrlCodec.encode(this.getSearchName(), "UTF-8"));
        }
        if (StringUtils.isNotBlank((String)this.getSearchOwnerUserName())) {
            url.append("&searchOwnerUserName=").append(JiraUrlCodec.encode(this.getSearchOwnerUserName(), "UTF-8"));
        }
        if (StringUtils.isNotBlank((String)this.getSortColumn())) {
            url.append("&sortColumn=").append(JiraUrlCodec.encode(this.getSortColumn(), "UTF-8"));
            url.append("&sortAscending=").append(JiraUrlCodec.encode(this.getSortAscending(), "UTF-8"));
            url.append("&pagingOffset=").append(JiraUrlCodec.encode(this.getPagingOffset(), "UTF-8"));
        }
        return url.toString();
    }

    protected JiraServiceContext getJiraServiceContext(String owner) {
        JiraServiceContext ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(UserUtils.getUser(owner)) : this.getJiraServiceContext();
        return ctx;
    }

    protected JiraServiceContext getJiraServiceContext(long id) {
        PortalPage dashboard = this.getDashboard(id);
        JiraServiceContext ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(UserUtils.getUser(dashboard.getOwnerUserName())) : this.getJiraServiceContext();
        return ctx;
    }

    private PortalPage getDashboard(long id) {
        return this.portalPageManager.getPortalPageById(id);
    }
}

