/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextManagementBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ManageConfigurationScheme
extends JiraWebActionSupport {
    public static final String REDIRECT_URL_PREFIX = "ConfigureCustomField!default.jspa?customFieldId=";
    private Long fieldConfigSchemeId;
    private Long customFieldId;
    private FieldConfigScheme fieldConfigScheme;
    private String name;
    private String description;
    private boolean global = true;
    private boolean basicMode = true;
    private Long[] projectCategories;
    private Long[] projects;
    private String[] issuetypes = new String[]{"-1"};
    private Long[] fieldConfigIds = new Long[0];
    protected final CustomFieldManager customFieldManager;
    protected final FieldConfigSchemeManager fieldConfigSchemeManager;
    protected final FieldConfigManager fieldConfigManager;
    private final SubTaskManager subTaskManager;
    protected final ProjectManager projectManager;
    protected final ConstantsManager constantsManager;
    protected final JiraContextTreeManager treeManager;
    protected final ReindexMessageManager reindexMessageManager;
    protected final CustomFieldContextConfigHelper customFieldContextConfigHelper;

    public ManageConfigurationScheme(FieldConfigManager fieldConfigManager, CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager, ConstantsManager constantsManager, JiraContextTreeManager treeManager, SubTaskManager subTaskManager, ReindexMessageManager reindexMessageManager, CustomFieldContextConfigHelper customFieldContextConfigHelper) {
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.treeManager = treeManager;
        this.fieldConfigManager = fieldConfigManager;
        this.subTaskManager = subTaskManager;
        this.reindexMessageManager = Assertions.notNull("reindexMessageManager", reindexMessageManager);
        this.customFieldContextConfigHelper = Assertions.notNull("customFieldContextConfigHelper", customFieldContextConfigHelper);
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.enter.name"));
        }
        if (this.issuetypes == null || this.issuetypes.length == 0) {
            this.addError("issuetypes", this.getText("admin.errors.must.select.issue.type"));
        }
        if (!(this.isGlobal() || this.projects != null && this.projects.length != 0)) {
            this.addError("projects", this.getText("admin.errors.must.select.project"));
        }
    }

    public String doDefault() throws Exception {
        FieldConfigScheme configScheme = this.getConfig();
        this.setGlobal(this.isGlobalAvailable());
        if (configScheme != null) {
            this.setName(configScheme.getName());
            this.setDescription(configScheme.getDescription());
            if (configScheme.isBasicMode()) {
                this.setBasicMode(true);
                this.setGlobal(configScheme.isAllProjects());
                Set<GenericValue> issueTypesList = configScheme.getAssociatedIssueTypes();
                this.setIssuetypes(GenericValueUtils.transformToStrings(issueTypesList, "id"));
                List<GenericValue> projectCategoriesList = configScheme.getAssociatedProjectCategories();
                this.setProjectCategories(GenericValueUtils.transformToLongIds(projectCategoriesList));
                List<GenericValue> projectsList = configScheme.getAssociatedProjects();
                this.setProjects(GenericValueUtils.transformToLongIds(projectsList));
                MultiMap configMap = configScheme.getConfigsByConfig();
                if (configMap == null) {
                    this.fieldConfigIds = new Long[0];
                } else {
                    Set entries = configScheme.getConfigsByConfig().keySet();
                    this.fieldConfigIds = new Long[entries.size()];
                    int i = 0;
                    for (FieldConfig config : entries) {
                        this.fieldConfigIds[i] = config.getId();
                        ++i;
                    }
                }
            } else {
                this.setBasicMode(false);
            }
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        FieldConfigScheme configScheme = new FieldConfigScheme.Builder(this.getConfig()).setName(this.getName()).setDescription(this.getDescription()).toFieldConfigScheme();
        if (this.isBasicMode()) {
            boolean messageRequired;
            List<JiraContextNode> contexts = CustomFieldUtils.buildJiraIssueContexts(this.isGlobal(), this.getProjectCategories(), this.getProjects(), this.treeManager);
            List<GenericValue> issueTypes = CustomFieldUtils.buildIssueTypes(this.constantsManager, this.getIssuetypes());
            if (configScheme.getId() == null) {
                messageRequired = this.customFieldContextConfigHelper.doesAddingContextToCustomFieldAffectIssues(this.getLoggedInUser(), this.getCustomField(), contexts, issueTypes, false);
                configScheme = this.fieldConfigSchemeManager.createFieldConfigScheme(configScheme, contexts, issueTypes, this.getCustomField());
            } else {
                messageRequired = this.customFieldContextConfigHelper.doesChangingContextAffectIssues(this.getLoggedInUser(), this.getCustomField(), configScheme, this.isGlobal(), contexts, issueTypes);
                if (issueTypes != null) {
                    Long configId = this.getFieldConfigIds()[0];
                    FieldConfig config = this.fieldConfigManager.getFieldConfig(configId);
                    HashMap<String, FieldConfig> configs = new HashMap<String, FieldConfig>(issueTypes.size());
                    for (GenericValue issueType : issueTypes) {
                        String issueTypeId = issueType == null ? null : issueType.getString("id");
                        configs.put(issueTypeId, config);
                    }
                    configScheme = new FieldConfigScheme.Builder(configScheme).setConfigs(configs).toFieldConfigScheme();
                }
                configScheme = this.fieldConfigSchemeManager.updateFieldConfigScheme(configScheme, contexts, this.getCustomField());
            }
            if (messageRequired) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
            }
            this.fieldConfigScheme = configScheme;
        }
        ManagerFactory.getFieldManager().refresh();
        return this.redirectToView();
    }

    @RequiresXsrfCheck
    public String doRemove() throws Exception {
        FieldConfigScheme configScheme = this.getConfig();
        if (this.customFieldContextConfigHelper.doesRemovingSchemeFromCustomFieldAffectIssues(this.getLoggedInUser(), this.getCustomField(), configScheme)) {
            this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.custom.fields");
        }
        this.fieldConfigSchemeManager.removeFieldConfigScheme(configScheme.getId());
        ManagerFactory.getFieldManager().refresh();
        return this.redirectToView();
    }

    public FieldConfigScheme getConfig() {
        if (this.fieldConfigScheme == null && this.fieldConfigSchemeId != null) {
            this.fieldConfigScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(this.fieldConfigSchemeId);
        }
        return this.fieldConfigScheme;
    }

    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getCustomFieldId());
    }

    public Collection getAllProjectCategories() throws Exception {
        return this.projectManager.getProjectCategories();
    }

    public Collection getAllProjects() throws Exception {
        Collection<Object> availableProjects = Collections.EMPTY_LIST;
        Collection<GenericValue> projects = this.projectManager.getProjects();
        if (projects != null) {
            List<GenericValue> currentlySlectedProjects;
            availableProjects = new ArrayList<GenericValue>(projects);
            availableProjects = CollectionUtils.subtract(availableProjects, this.getCustomField().getAssociatedProjects());
            FieldConfigScheme fieldConfigScheme = this.getFieldConfigScheme();
            if (fieldConfigScheme != null && (currentlySlectedProjects = fieldConfigScheme.getAssociatedProjects()) != null) {
                availableProjects.addAll(currentlySlectedProjects);
            }
        }
        return availableProjects;
    }

    public Collection getAllIssueTypes() throws Exception {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeObjects();
        }
        ArrayList<IssueType> returnValues = new ArrayList<IssueType>(this.constantsManager.getRegularIssueTypeObjects());
        ArrayList intersection = new ArrayList(CollectionUtils.intersection(this.constantsManager.getSubTaskIssueTypes(), this.getCustomField().getAssociatedIssueTypes()));
        Collections.sort(intersection);
        for (GenericValue genericValue : intersection) {
            returnValues.add(0, this.constantsManager.getIssueTypeObject(genericValue.getString("id")));
        }
        return returnValues;
    }

    private String redirectToView() {
        return this.getRedirect(REDIRECT_URL_PREFIX + this.getCustomField().getIdAsLong() + "&fieldConfigSchemeId=" + this.getConfig().getId());
    }

    public boolean isGlobalAvailable() {
        if (!this.getCustomField().isAllProjects()) {
            return true;
        }
        return this.getFieldConfigScheme() != null && this.getFieldConfigScheme().isAllProjects();
    }

    public void setFieldConfigSchemeId(Long fieldConfigSchemeId) {
        this.fieldConfigSchemeId = fieldConfigSchemeId;
    }

    public Long getFieldConfigSchemeId() {
        return this.fieldConfigSchemeId;
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public String[] getIssuetypes() {
        return this.issuetypes;
    }

    public void setIssuetypes(String[] issuetypes) {
        this.issuetypes = issuetypes;
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public void setCustomFieldId(Long customFieldId) {
        this.customFieldId = customFieldId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FieldConfigScheme getFieldConfigScheme() {
        return this.fieldConfigScheme;
    }

    public void setFieldConfigScheme(FieldConfigScheme fieldConfigScheme) {
        this.fieldConfigScheme = fieldConfigScheme;
    }

    public Long[] getProjectCategories() {
        return this.projectCategories;
    }

    public void setProjectCategories(Long[] projectCategories) {
        this.projectCategories = projectCategories;
    }

    public Map getGlobalContextOption() {
        return CustomFieldContextManagementBean.getGlobalContextOption();
    }

    public boolean isBasicMode() {
        return this.basicMode;
    }

    public void setBasicMode(boolean basicMode) {
        this.basicMode = basicMode;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public Long[] getFieldConfigIds() {
        return this.fieldConfigIds;
    }

    public void setFieldConfigIds(Long[] fieldConfigIds) {
        this.fieldConfigIds = fieldConfigIds;
    }
}

