/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class CustomFieldContextConfigHelperImpl
implements CustomFieldContextConfigHelper {
    private static final Logger log = Logger.getLogger(CustomFieldContextConfigHelperImpl.class);
    private final SearchProvider searchProvider;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public CustomFieldContextConfigHelperImpl(SearchProvider searchProvider, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.searchProvider = Assertions.notNull("searchProvider", searchProvider);
        this.fieldConfigSchemeManager = Assertions.notNull("fieldConfigSchemeManager", fieldConfigSchemeManager);
    }

    @Override
    public boolean doesAddingContextToCustomFieldAffectIssues(User user, CustomField customField, List<JiraContextNode> projectContexts, List<GenericValue> issueTypes, boolean isNewCustomField) {
        if (!isNewCustomField && this.doesCustomFieldHaveGlobalScheme(customField)) {
            return false;
        }
        return this.doesContextHaveIssues(user, projectContexts, issueTypes);
    }

    @Override
    public boolean doesChangingContextAffectIssues(User user, CustomField customField, FieldConfigScheme oldFieldConfigScheme, boolean isNewSchemeGlobal, List<JiraContextNode> projectContexts, List<GenericValue> issueTypes) {
        boolean isOldSchemeGlobal = oldFieldConfigScheme.isGlobal();
        if (!isOldSchemeGlobal && !isNewSchemeGlobal) {
            if (this.doesCustomFieldHaveGlobalScheme(customField)) {
                return false;
            }
            if (this.doesContextHaveIssues(user, projectContexts, issueTypes)) {
                return true;
            }
            return this.doesFieldConfigSchemeHaveIssues(user, oldFieldConfigScheme);
        }
        return this.doesGlobalContextHaveIssues(user);
    }

    @Override
    public boolean doesRemovingSchemeFromCustomFieldAffectIssues(User user, CustomField customField, FieldConfigScheme fieldConfigScheme) {
        if (fieldConfigScheme.isGlobal()) {
            List<FieldConfigScheme> nonGlobalSchemes = this.getNonGlobalSchemesForCustomField(customField);
            if (nonGlobalSchemes.isEmpty()) {
                return this.doesGlobalContextHaveIssues(user);
            }
            JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
            for (FieldConfigScheme scheme : nonGlobalSchemes) {
                List<Object> projects = scheme.getAssociatedProjects();
                projects = projects == null ? Collections.emptyList() : Collections.unmodifiableList(projects);
                Set<Object> issueTypes = scheme.getAssociatedIssueTypes();
                issueTypes = issueTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(issueTypes);
                List<Long> projectIds = this.filterAndTransformGenericValues(projects);
                List<Long> issueTypeIds = this.filterAndTransformGenericValues(issueTypes);
                clauseBuilder.not().addClause(this.buildClause(projectIds, issueTypeIds).buildClause());
            }
            return this.doesQueryHaveIssues(user, clauseBuilder.buildQuery());
        }
        if (this.doesCustomFieldHaveGlobalScheme(customField)) {
            return false;
        }
        return this.doesFieldConfigSchemeHaveIssues(user, fieldConfigScheme);
    }

    boolean doesContextHaveIssues(User user, List<JiraContextNode> projectContexts, List<GenericValue> issueTypes) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (JiraContextNode context : projectContexts) {
            if (context == null || context.getProjectObject() == null) continue;
            projectIds.add(context.getProjectObject().getId());
        }
        ArrayList<Long> issueTypeIds = new ArrayList();
        if (issueTypes != null) {
            issueTypeIds = this.filterAndTransformGenericValues(issueTypes);
        }
        return this._doesContextHaveIssues(user, projectIds, issueTypeIds);
    }

    boolean doesContextHaveIssues(User user, List<GenericValue> projects, Set<GenericValue> issueTypes) {
        ArrayList<Long> projectIds = new ArrayList();
        if (projects != null) {
            projectIds = this.filterAndTransformGenericValues(projects);
        }
        ArrayList<Long> issueTypeIds = new ArrayList();
        if (issueTypes != null) {
            issueTypeIds = this.filterAndTransformGenericValues(issueTypes);
        }
        return this._doesContextHaveIssues(user, projectIds, issueTypeIds);
    }

    boolean doesGlobalContextHaveIssues(User user) {
        return this._doesContextHaveIssues(user, Collections.<Long>emptyList(), Collections.<Long>emptyList());
    }

    boolean _doesContextHaveIssues(User user, List<Long> projectIds, List<Long> issueTypeIds) {
        JqlClauseBuilder clauseBuilder = this.buildClause(projectIds, issueTypeIds);
        return this.doesQueryHaveIssues(user, clauseBuilder.buildQuery());
    }

    boolean doesFieldConfigSchemeHaveIssues(User user, FieldConfigScheme fieldConfigScheme) {
        List<Object> projects = fieldConfigScheme.getAssociatedProjects();
        projects = projects == null ? Collections.emptyList() : Collections.unmodifiableList(projects);
        Set<Object> issueTypes = fieldConfigScheme.getAssociatedIssueTypes();
        issueTypes = issueTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(issueTypes);
        return this.doesContextHaveIssues(user, projects, issueTypes);
    }

    private boolean doesCustomFieldHaveGlobalScheme(CustomField customField) {
        List<FieldConfigScheme> schemes = this.fieldConfigSchemeManager.getConfigSchemesForField(customField);
        for (FieldConfigScheme scheme : schemes) {
            if (!scheme.isGlobal()) continue;
            return true;
        }
        return false;
    }

    private List<FieldConfigScheme> getNonGlobalSchemesForCustomField(CustomField customField) {
        List<FieldConfigScheme> schemes = this.fieldConfigSchemeManager.getConfigSchemesForField(customField);
        ArrayList<FieldConfigScheme> result = new ArrayList<FieldConfigScheme>();
        for (FieldConfigScheme scheme : schemes) {
            if (scheme.isGlobal()) continue;
            result.add(scheme);
        }
        return result;
    }

    private JqlClauseBuilder buildClause(List<Long> projectIds, List<Long> issueTypeIds) {
        JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder().defaultAnd();
        if (!projectIds.isEmpty()) {
            clauseBuilder.project().inNumbers(projectIds);
        }
        if (!issueTypeIds.isEmpty()) {
            clauseBuilder.issueType().inNumbers(issueTypeIds);
        }
        return clauseBuilder;
    }

    private List<Long> filterAndTransformGenericValues(Collection<GenericValue> issueTypes) {
        Predicate<GenericValue> notNullPredicate = new Predicate<GenericValue>(){

            @Override
            public boolean evaluate(GenericValue input) {
                return input != null;
            }
        };
        Function<GenericValue, Long> idTransformer = new Function<GenericValue, Long>(){

            @Override
            public Long get(GenericValue input) {
                return new Long(input.getString("id"));
            }
        };
        return CollectionUtil.transform(CollectionUtil.filter(issueTypes.iterator(), notNullPredicate), idTransformer);
    }

    private boolean doesQueryHaveIssues(User user, Query query) {
        try {
            long issueCount = this.searchProvider.searchCountOverrideSecurity(query, user);
            return issueCount > 0L;
        }
        catch (SearchException e) {
            log.warn((Object)e, (Throwable)e);
            return true;
        }
    }
}

