/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.configurableobjects.ConfigurableObjectUtil;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.ServiceTypes;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@WebSudoRequired
public class ViewServices
extends JiraWebActionSupport {
    private static final Logger LOG = Logger.getLogger(ViewServices.class);
    private final ServiceManager serviceManager;
    private final ComponentClassManager componentClassManager;
    private final ServiceTypes serviceTypes;
    private final InBuiltServiceTypes inBuiltServiceTypes;
    private Long delete;
    private String name;
    private String clazz;
    private long delay = 1L;

    public ViewServices(ServiceManager serviceManager, ComponentClassManager componentClassManager, InBuiltServiceTypes inBuiltServiceTypes, ServiceTypes serviceTypes) {
        this.serviceManager = serviceManager;
        this.componentClassManager = componentClassManager;
        this.inBuiltServiceTypes = inBuiltServiceTypes;
        this.serviceTypes = serviceTypes;
    }

    protected void doValidation() {
        if (this.delete == null) {
            if (this.name == null || "".equals(this.name.trim())) {
                this.addError("name", this.getText("admin.errors.specify.service.name"));
            }
            if (this.clazz == null || "".equals(this.clazz.trim())) {
                this.addError("clazz", this.getText("admin.errors.specify.service.class"));
            }
            boolean serviceExists = false;
            for (JiraServiceContainer service : this.serviceManager.getServices()) {
                if (this.name.equalsIgnoreCase(service.getName())) {
                    this.addError("name", this.getText("admin.errors.service.with.name.exists", this.name));
                }
                if (!this.clazz.equals(service.getServiceClass())) continue;
                serviceExists = service.isUnique();
            }
            if (!this.getHasErrors()) {
                try {
                    this.componentClassManager.newInstance(this.clazz);
                    if (serviceExists) {
                        this.addError("clazz", this.getText("admin.errors.cannot.add.service"));
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.addError("clazz", this.getText("admin.errors.class.not.found", this.clazz));
                    this.log.debug((Object)("Class [" + this.clazz + "] was not found when adding service"), (Throwable)ex);
                }
                catch (ClassCastException e) {
                    this.addError("clazz", this.getText("admin.errors.incorrect.class.type", this.clazz));
                    this.log.debug((Object)("Class [" + this.clazz + "] is not of type JiraService"), (Throwable)e);
                }
                catch (Exception e) {
                    this.addError("clazz", this.getText("admin.errors.exception.loading.class") + " [" + e.getMessage() + "].");
                    this.log.debug((Object)("Exception loading class: [" + e.getMessage() + "]"), (Throwable)e);
                }
            }
            if (this.delay < 1L) {
                this.addError("delay", this.getText("admin.errors.delay.too.short"));
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.delete != null) {
            if (this.canDeleteService(this.delete)) {
                LOG.debug((Object)("Removing Service with id " + this.delete));
                this.serviceManager.removeService(this.delete);
                return this.getRedirect("ViewServices!default.jspa");
            }
            return "securitybreach";
        }
        if (this.name != null && this.clazz != null) {
            if (this.canAddService(this.clazz)) {
                try {
                    JiraServiceContainer serviceContainer = this.serviceManager.addService(this.getName(), this.getClazz(), this.getDelay() * 60L * 1000L);
                    this.delay = 1L;
                    return this.getRedirect("EditService!default.jspa?id=" + serviceContainer.getId());
                }
                catch (Exception e) {
                    this.log.error((Object)("Unable to add service: " + this.getName()), (Throwable)e);
                    this.addErrorMessage(this.getText("admin.errors.error.adding.service") + " " + e.toString() + ".");
                }
            } else {
                return "securitybreach";
            }
        }
        return this.getRedirect("ViewServices!default.jspa");
    }

    private boolean canAddService(String clazz) {
        return this.serviceTypes.isManageableBy(this.getLoggedInUser(), clazz);
    }

    private boolean canDeleteService(final Long serviceId) throws Exception {
        return Iterables.any(this.serviceManager.getServicesManageableBy(this.getLoggedInUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser.getId());
            }
        });
    }

    public Collection getServices() {
        return ImmutableList.copyOf(this.serviceManager.getServicesManageableBy(this.getLoggedInUser()));
    }

    public Collection getInBuiltServiceTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.inBuiltServiceTypes.manageableBy(this.getLoggedInUser()), (Predicate)new Predicate<InBuiltServiceTypes.InBuiltServiceType>(){

            public boolean apply(InBuiltServiceTypes.InBuiltServiceType input) {
                return input.getType() != null && !MailFetcherService.class.isAssignableFrom(input.getType());
            }
        }));
    }

    public Map getPropertyMap(JiraServiceContainer serviceContainer) throws Exception {
        try {
            return ConfigurableObjectUtil.getPropertyMap(serviceContainer);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            return MapBuilder.build("ERROR", "Error occurred getting properties. See log file for details.");
        }
    }

    public long getDelayInMins(JiraServiceContainer serviceContainer) {
        return serviceContainer.getDelay() / 60000L;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setClazz(String clazz) {
        this.clazz = clazz.trim();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelete(Long delete) {
        this.delete = delete;
    }

    public boolean isHandlerUsingObsoleteSettings(JiraServiceContainer service) {
        try {
            Map<String, String> params = ConfigurableObjectUtil.getPropertyMap(service);
            return params != null && params.containsKey("handler.params") && (params.get("handler.params").contains("port=") || params.get("handler.params").contains("usessl="));
        }
        catch (Exception e) {
            return false;
        }
    }
}

