/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class MailQueueAdmin
extends JiraWebActionSupport {
    boolean flush = false;
    boolean resend = false;
    boolean delete = false;
    boolean unstick = false;
    private String page = "";
    private final MailQueue mailQueue;
    private final NotificationSchemeManager notificationSchemeManager;
    private final ApplicationProperties applicationProperties;

    public MailQueueAdmin(MailQueue mailQueue, NotificationSchemeManager notificationSchemeManager, ApplicationProperties applicationProperties) {
        this.mailQueue = mailQueue;
        this.notificationSchemeManager = notificationSchemeManager;
        this.applicationProperties = applicationProperties;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(this.applicationProperties.getString("jira.baseurl"), null);
        if (this.flush) {
            this.getMailQueue().sendBuffer();
        } else if (this.resend) {
            this.getMailQueue().resendErrorQueue();
        } else if (this.delete) {
            this.getMailQueue().emptyErrorQueue();
        } else if (this.unstick) {
            this.getMailQueue().unstickQueue();
        }
        return this.getRedirect("MailQueueAdmin!default.jspa?page=" + this.getPage());
    }

    public MailQueue getMailQueue() {
        return this.mailQueue;
    }

    public Collection<MailQueueItem> getQueuedItems() {
        Queue queue = "errorqueue".equals(this.page) ? this.getMailQueue().getErrorQueue() : this.getMailQueue().getQueue();
        ArrayList<MailQueueItem> queueList = new ArrayList<MailQueueItem>();
        queueList.addAll(queue);
        return queueList;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setResend(boolean resend) {
        this.resend = resend;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setUnstick(boolean unstick) {
        this.unstick = unstick;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public boolean isSending() {
        return this.getMailQueue().isSending();
    }

    public String getPrettySendingStartTime() {
        OutlookDate outlookDate = ManagerFactory.getOutlookDateManager().getOutlookDate(this.getLocale());
        if (this.isSending()) {
            return outlookDate.formatDMYHMS(this.getMailQueue().getSendingStarted());
        }
        return "";
    }

    public String getTimeSpentSendingCurrentItem() {
        if (this.isSending()) {
            Timestamp started = this.getMailQueue().getSendingStarted();
            long timeTaken = System.currentTimeMillis() - started.getTime();
            return DateUtils.getDurationString((long)(timeTaken / 1000L));
        }
        return "";
    }

    public boolean isMailSendingDisabled() {
        return MailFactory.isSendingDisabled();
    }

    public boolean isHasMailServer() {
        try {
            SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (smtp != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isEnabledNotificationSchemes() {
        Collection<GenericValue> projects = this.getProjectManager().getProjects();
        for (GenericValue project : projects) {
            try {
                List<GenericValue> projectSchemes = this.notificationSchemeManager.getSchemes(project);
                if (projectSchemes.size() <= 0) continue;
                return true;
            }
            catch (GenericEntityException e) {
            }
        }
        return false;
    }
}

