/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.ofbiz.core.entity.GenericValue;

public class IconPicker
extends JiraWebActionSupport {
    private String fieldType;
    private String formName;
    private List iconsOfType;
    private Properties iconProperties;
    private MultiMap issueConstants;
    private static final String ICON_IMAGES_PROPERTIES = "iconimages.properties";
    private final ConstantsManager constantsManager;

    public IconPicker(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getFieldName() {
        return "issue.field." + this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public List getIconUrls(String fieldType) {
        if (this.iconsOfType == null) {
            this.iconsOfType = new ArrayList();
            String fieldTypeLowerCase = fieldType.toLowerCase();
            if (this.getIconProperties() != null) {
                for (String string : this.getIconProperties().keySet()) {
                    if (!string.startsWith("icon." + fieldTypeLowerCase)) continue;
                    this.iconsOfType.add(string);
                }
            } else {
                this.addErrorMessage(this.getText("admin.errors.unable.to.load.properties", "'iconimages.properties'"));
            }
        }
        Collections.sort(this.iconsOfType);
        return this.iconsOfType;
    }

    public String getImage(String key) {
        return this.getIconProperties().getProperty(key);
    }

    private Properties getIconProperties() {
        if (this.iconProperties == null) {
            this.iconProperties = new Properties();
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)ICON_IMAGES_PROPERTIES, this.getClass());
            try {
                this.iconProperties.load(in);
                in.close();
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to load icon properties from 'iconimages.properties'.");
                return null;
            }
        }
        return this.iconProperties;
    }

    public Collection getAssociatedImages(String imageLocation) {
        return (Collection)this.getIssueConstants().get((Object)imageLocation);
    }

    private MultiMap getIssueConstants() {
        if (this.issueConstants == null) {
            Collection<GenericValue> fields;
            this.issueConstants = new MultiHashMap();
            if (this.fieldType.equals("status")) {
                fields = this.constantsManager.getStatuses();
            } else if (this.fieldType.equals("issuetype")) {
                fields = this.constantsManager.getIssueTypes();
            } else if (this.fieldType.equals("priority")) {
                fields = this.constantsManager.getPriorities();
            } else if (this.fieldType.equals("subtasks")) {
                fields = this.constantsManager.getSubTaskIssueTypes();
            } else {
                throw new IllegalArgumentException("Invalid field type selected.");
            }
            for (GenericValue issueConstantGV : fields) {
                String associatedImage = issueConstantGV.getString("iconurl");
                this.issueConstants.put((Object)associatedImage, (Object)this.constantsManager.getIssueConstant(issueConstantGV));
            }
        }
        return this.issueConstants;
    }
}

