/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

@WebSudoRequired
public class GlobalPermissions
extends ProjectActionSupport {
    private Map permTypes;
    private String groupName;
    private int permType = -1;
    private String action = "view";
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserUtil userUtil;
    private final GroupManager groupManager;

    public GlobalPermissions(GlobalPermissionManager globalPermissionManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, UserUtil userUtil, GroupManager groupManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.globalPermissionManager = globalPermissionManager;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public void doValidation() {
        if (this.permType >= 0) {
            if (!Permissions.isGlobalPermission(this.permType)) {
                this.addError("permType", this.getText("admin.errors.permissions.inexistent.permission"));
            }
            if (this.groupName != null) {
                if (!"del".equals(this.action) && !"confirm".equals(this.action)) {
                    Group group = this.groupManager.getGroup(this.groupName);
                    if (group == null) {
                        this.addError("groupName", this.getText("admin.errors.permissions.inexistent.group", "'" + this.groupName + "'"));
                    }
                    if (this.permType == 1 && this.getAdministrativeGroups().contains(group)) {
                        this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.groupName, this.getPermTypeDisplayName(this.permType)));
                    }
                } else {
                    Collection<String> groupNames = this.globalPermissionManager.getGroupNames(this.permType);
                    if (!groupNames.contains(this.groupName)) {
                        this.addErrorMessage(this.getText("admin.errors.permissions.delete.group.not.in.permission", this.groupName, this.getPermTypeDisplayName(this.permType)));
                    }
                }
            } else if (this.permType == 1 && "add".equals(this.action)) {
                this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.getText("admin.common.words.anyone"), this.getPermTypeDisplayName(this.permType)));
            }
            this.validateAdd();
            this.validateDelete();
        } else if ("add".equals(this.action)) {
            this.addError("permType", this.getText("admin.errors.permissions.must.select.permission"));
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (this.permType >= 0) {
            if ("del".equals(this.action)) {
                this.removePermission(this.permType, this.groupName);
                this.action = "view";
                return this.getPermissionRedirect();
            }
            if ("confirm".equals(this.action)) {
                return "confirm";
            }
            if ("add".equals(this.action)) {
                Group group = this.groupName == null ? null : this.groupManager.getGroup(this.groupName);
                this.createPermission(this.permType, group);
                return this.getPermissionRedirect();
            }
        }
        return this.getResult();
    }

    protected void validateDelete() {
        if ("del".equals(this.action) || "confirm".equals(this.action)) {
            if (this.permType == 0) {
                boolean removingAllPerms;
                boolean bl = removingAllPerms = this.globalPermissionGroupAssociationUtil.isRemovingAllMyAdminGroups(EasyList.build((Object)this.groupName), this.getLoggedInUser()) && !this.globalPermissionManager.hasPermission(44, this.getLoggedInUser());
                if (removingAllPerms) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission"));
                }
            } else if (this.permType == 44) {
                if (!this.globalPermissionManager.hasPermission(44, this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin.only"));
                } else if (this.globalPermissionGroupAssociationUtil.isRemovingAllMySysAdminGroups(EasyList.build((Object)this.groupName), this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin"));
                }
            }
        }
    }

    protected void validateAdd() {
        if ("add".equals(this.action) && !this.getPermTypes().containsKey(new Integer(this.permType))) {
            this.addErrorMessage(this.getText("admin.errors.permissions.not.have.permission.to.add"));
        }
    }

    protected String getPermissionRedirect() throws Exception {
        return this.getRedirect("GlobalPermissions!default.jspa");
    }

    protected void createPermission(int permType, Group group) throws CreateException {
        String groupName;
        String string = groupName = group == null ? null : group.getName();
        if (!this.globalPermissionManager.getGroupNames(permType).contains(groupName)) {
            this.globalPermissionManager.addPermission(permType, groupName);
        }
    }

    private void removePermission(int permType, String groupName) throws RemoveException {
        Group group = groupName == null ? null : this.groupManager.getGroup(groupName);
        String groupToDelete = null;
        if (group != null) {
            groupToDelete = group.getName();
        } else if (groupName != null) {
            groupToDelete = groupName;
        }
        this.globalPermissionManager.removePermission(permType, groupToDelete);
    }

    public Collection getPermissionGroups(Integer permType) {
        return this.globalPermissionManager.getPermissions(permType);
    }

    public Collection getGroups() {
        return this.groupManager.getAllGroups();
    }

    public int getPermType() {
        return this.permType;
    }

    public String getPermTypeName() {
        return this.getPermTypeDisplayName(this.permType);
    }

    public void setPermType(int permType) {
        this.permType = permType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = TextUtils.stringSet((String)groupName) ? groupName : null;
    }

    public void setAction(String action) {
        this.action = "del".equalsIgnoreCase(action) || "delete".equalsIgnoreCase(action) ? "del" : ("confirm".equalsIgnoreCase(action) ? "confirm" : "add");
    }

    public boolean isConfirm() {
        return "confirm".equalsIgnoreCase(this.action);
    }

    public String getPermTypeDisplayName(int permType) {
        String name = permType == 44 ? "admin.global.permissions.system.administer" : (permType == 0 ? "admin.global.permissions.administer" : (permType == 1 ? "admin.global.permissions.use" : (permType == 27 ? "admin.global.permissions.user.picker" : (permType == 22 ? "admin.global.permissions.create.shared.filter" : (permType == 24 ? "admin.global.permissions.manage.group.filter.subscriptions" : (permType == 33 ? "admin.global.permissions.bulk.change" : "common.words.unknown"))))));
        return this.getText(name);
    }

    public Map getPermTypes() {
        if (this.permTypes == null) {
            this.permTypes = new ListOrderedMap();
            if (this.globalPermissionManager.hasPermission(44, this.getLoggedInUser())) {
                this.permTypes.put(new Integer(44), this.getPermTypeDisplayName(44));
            }
            this.permTypes.put(new Integer(0), this.getPermTypeDisplayName(0));
            this.permTypes.put(new Integer(1), this.getPermTypeDisplayName(1));
            this.permTypes.put(new Integer(27), this.getPermTypeDisplayName(27));
            this.permTypes.put(new Integer(22), this.getPermTypeDisplayName(22));
            this.permTypes.put(new Integer(24), this.getPermTypeDisplayName(24));
            this.permTypes.put(new Integer(33), this.getPermTypeDisplayName(33));
        }
        return this.permTypes;
    }

    public String getDescription(Integer permType) {
        return Permissions.getDescription(permType);
    }

    public boolean hasExceededUserLimit() {
        return this.userUtil.hasExceededUserLimit();
    }

    private Collection<Group> getAdministrativeGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.globalPermissionManager.getGroupsWithPermission(0));
        groups.addAll(this.globalPermissionManager.getGroupsWithPermission(44));
        return Collections.unmodifiableCollection(groups);
    }

    private static final class Actions {
        private static final String VIEW = "view";
        private static final String ADD = "add";
        private static final String DEL = "del";
        private static final String DELETE = "delete";
        private static final String CONFIRM = "confirm";

        private Actions() {
        }
    }
}

