/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import webwork.action.ParameterAware;

@WebSudoRequired
public class EditService
extends JiraWebActionSupport
implements ParameterAware {
    private final ServiceManager serviceManager;
    private Long id;
    private Map params;
    private long delay;
    private ObjectConfiguration oc;
    private String removedPath;
    private JiraServiceContainer service = null;
    private static final Set<String> BANNED_KEYS = new HashSet<String>();

    public EditService(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public String doDefault() throws Exception {
        if (this.canEditService(this.id)) {
            this.delay = this.getService().getDelay() / 60000L;
            this.getObjectConfigurationKeys();
            return "input";
        }
        return "securitybreach";
    }

    private boolean canEditService(final Long serviceId) throws Exception {
        return Iterables.any(this.serviceManager.getServicesManageableBy(this.getLoggedInUser()), (Predicate)new Predicate<JiraServiceContainer>(){

            public boolean apply(@Nullable JiraServiceContainer aServiceManageableByTheUser) {
                return serviceId.equals(aServiceManageableByTheUser.getId());
            }
        });
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.canEditService(this.id)) {
            try {
                this.serviceManager.editService(this.id, this.delay * 60000L, this.primeParamsWithSavedValues(this.params));
            }
            catch (Exception e) {
                this.log.error((Object)("Error occurred trying to update service properties: " + e), (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.error.occured.trying.to.update.service.properties", e));
            }
            if (this.getHasErrorMessages()) {
                return "error";
            }
            return this.getRedirect("ViewServices!default.jspa");
        }
        return "securitybreach";
    }

    private Map<String, String[]> primeParamsWithSavedValues(Map<String, String[]> webParameters) throws Exception {
        HashMap<String, String[]> newParameters = new HashMap<String, String[]>();
        newParameters.putAll(webParameters);
        for (String bannedKey : BANNED_KEYS) {
            String value = this.getParamValue(bannedKey);
            if (!StringUtils.isNotBlank((String)value)) continue;
            newParameters.put(bannedKey, new String[]{value});
        }
        return newParameters;
    }

    protected void doValidation() {
        if (!this.serviceManager.containsServiceWithId(this.id)) {
            this.addErrorMessage(this.getText("admin.errors.service.does.not.exist"));
        }
        if (this.delay < 1L) {
            this.addError("delay", this.getText("admin.errors.delay.too.short"));
        }
        if (this.params.containsKey("subdirectory")) {
            try {
                String subdirectory = ((String[])this.params.get("subdirectory"))[0];
                File subdirectoryFile = new File(this.getJiraHome().getHome(), PathUtils.joinPaths(FileService.MAIL_DIR, subdirectory)).getCanonicalFile();
                File mailDir = new File(this.getJiraHome().getHome(), FileService.MAIL_DIR).getCanonicalFile();
                if (!subdirectoryFile.getParentFile().equals(mailDir) && !subdirectoryFile.equals(mailDir)) {
                    this.addError("subdirectory", this.getText("admin.errors.fileservice.directory.is.not.subdirectory"));
                }
                if (!subdirectoryFile.exists()) {
                    this.addError("subdirectory", this.getText("admin.errors.fileservice.directory.not.exist"));
                }
            }
            catch (IOException e) {
                this.addError("subdirectory", this.getText("admin.errors.fileservice.could.not.find"));
            }
            catch (Exception e) {
                this.addError("subdirectory", this.getText("admin.errors.fileservice.could.not.find"));
            }
        }
        super.doValidation();
    }

    public boolean isUnsafeService() {
        try {
            if (this.serviceManager.containsServiceWithId(this.id)) {
                JiraServiceContainer serviceWithId = this.serviceManager.getServiceWithId(this.id);
                String serviceClass = serviceWithId.getServiceClass();
                return "com.atlassian.jira.service.services.export.ExportService".equals(serviceClass) || "com.atlassian.jira.service.services.file.FileService".equals(serviceClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public ObjectConfiguration getObjectConfiguration() throws Exception {
        if (this.oc == null) {
            this.oc = this.getService().getObjectConfiguration();
        }
        return this.oc;
    }

    public String[] getObjectConfigurationKeys() throws Exception {
        String[] fieldKeys = this.getObjectConfiguration().getFieldKeys();
        ArrayList<String> sanitizedFieldKeys = new ArrayList<String>(fieldKeys.length);
        for (String fieldKey : fieldKeys) {
            if (!this.isBannedKey(fieldKey)) {
                sanitizedFieldKeys.add(fieldKey);
                continue;
            }
            this.removedPath = this.getParamValue(fieldKey);
        }
        return sanitizedFieldKeys.toArray(new String[sanitizedFieldKeys.size()]);
    }

    private boolean isBannedKey(String fieldKey) {
        return this.isUnsafeService() && BANNED_KEYS.contains(fieldKey);
    }

    private Map sanitizeParams(Map parameters) {
        HashMap sanitizedMap = new HashMap();
        sanitizedMap.putAll(parameters);
        Iterator iterator = sanitizedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!this.isBannedKey((String)entry.getKey())) continue;
            iterator.remove();
        }
        return sanitizedMap;
    }

    public void setParameters(Map map) {
        this.params = this.sanitizeParams(map);
    }

    public Map getParameters() {
        return this.params;
    }

    public String getParamValue(String s) throws Exception {
        if (this.getService().getProperties() != null) {
            return this.getService().getProperty(s);
        }
        return "";
    }

    public List getParamValues(String key) {
        Map inputParams = this.getParameters();
        if (inputParams == null) {
            return this.getDefaultValue(key);
        }
        Object val = inputParams.get(key);
        if (val == null) {
            return this.getDefaultValue(key);
        }
        if (val instanceof String[]) {
            return Arrays.asList((String[])val);
        }
        return Arrays.asList(val.toString());
    }

    private List getDefaultValue(String key) {
        try {
            String s = this.getObjectConfiguration().getFieldDefault(key);
            return s == null ? Collections.EMPTY_LIST : Arrays.asList(s);
        }
        catch (ObjectConfigurationException e) {
            this.log.warn((Object)("Unable to obtain default value for '" + key + "'. Using empy value."), (Throwable)((Object)e));
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to obtain default value for '" + key + "'. Using empy value."), (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public JiraServiceContainer getService() throws Exception {
        if (this.service == null) {
            this.service = this.serviceManager.getServiceWithId(this.id);
        }
        return this.service;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getDescription() throws Exception {
        return this.getObjectConfiguration().getDescription(null);
    }

    public String getRemovedPath() {
        return this.removedPath;
    }

    public boolean isValidMailParameters() {
        if (!JiraSystemProperties.isDecodeMailParameters() && this.id != null) {
            try {
                JiraServiceContainer serviceContainer = this.getService();
                if (serviceContainer != null) {
                    ImmutableSet mailServices = ImmutableSet.of((Object)MailFetcherService.class.getName(), (Object)FileService.class.getName());
                    return !mailServices.contains(serviceContainer.getServiceClass());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private JiraHome getJiraHome() {
        return ComponentManager.getComponentInstanceOfType(JiraHome.class);
    }

    public String getFileServiceBasePath() {
        return PathUtils.appendFileSeparator(PathUtils.joinPaths("[jira.home]", FileService.MAIL_DIR));
    }

    static {
        BANNED_KEYS.add("DIR_NAME");
        BANNED_KEYS.add("directory");
    }
}

