/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

@WebSudoRequired
public class EditAnnouncementBanner
extends JiraWebActionSupport {
    public static final String ANNOUNCEMENT_PREVIEW = "announcement_preview_banner_st";
    private String announcement;
    private String bannerVisibility;
    private ApplicationProperties applicationProperties;
    public static final String PUBLIC_BANNER = "public";
    public static final String PRIVATE_BANNER = "private";

    public EditAnnouncementBanner(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public String doDefault() throws Exception {
        String preview = this.request.getParameter(ANNOUNCEMENT_PREVIEW);
        this.announcement = preview == null ? this.applicationProperties.getDefaultBackedText("jira.alertheader") : preview;
        this.bannerVisibility = this.applicationProperties.getDefaultBackedString("jira.alertheader.visibility");
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.applicationProperties.setText("jira.alertheader", this.announcement);
        this.applicationProperties.setString("jira.alertheader.visibility", this.bannerVisibility);
        return "input";
    }

    public Collection<TextOption> getVisibilityModes() {
        return ImmutableList.of((Object)new TextOption(PUBLIC_BANNER, this.getText("admin.menu.optionsandsettings.announcement.banner.visibility.public")), (Object)new TextOption(PRIVATE_BANNER, this.getText("admin.menu.optionsandsettings.announcement.banner.visibility.private")));
    }

    public String getAnnouncement() {
        return this.announcement;
    }

    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public boolean isPreview() {
        return this.request.getParameter(ANNOUNCEMENT_PREVIEW) != null;
    }

    public String getBannerVisibility() {
        return this.bannerVisibility;
    }

    public void setBannerVisibility(String bannerVisibility) {
        this.bannerVisibility = bannerVisibility;
    }
}

