/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NameComparator;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.EditableColumnLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractViewIssueColumns
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private int operation;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MOVELEFT = 3;
    public static final int MOVERIGHT = 4;
    public static final int RESTORE = 5;
    public static final int SHOW_ACTIONS = 8;
    public static final int HIDE_ACTIONS = 9;
    private static final int SAMPLE_ISSUES_NUMBER = 5;
    private List<NavigableField> addableColumns;
    private String fieldId;
    private Integer fieldPosition;
    private final FieldManager fieldManager = ManagerFactory.getFieldManager();
    private final SearchProvider searchProvider = ComponentManager.getComponent(SearchProvider.class);
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory = ComponentManager.getComponent(SessionSearchObjectManagerFactory.class);

    public AbstractViewIssueColumns(IssueSearcherManager issueSearcherManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
    }

    protected String runOperation() throws Exception {
        switch (this.getOperation()) {
            case 1: {
                return this.doAdd();
            }
            case 2: {
                return this.doDelete();
            }
            case 3: {
                return this.doMoveLeft();
            }
            case 4: {
                return this.doMoveRight();
            }
            case 5: {
                return this.doRestoreDefault();
            }
            case 8: {
                return this.doShowActionsColumn();
            }
            case 9: {
                return this.doHideActionsColumn();
            }
        }
        this.addErrorMessage(this.getText("admin.errors.trying.to.perform.invalid.operation"));
        return "input";
    }

    private String doAdd() throws Exception {
        if (TextUtils.stringSet((String)this.getFieldId())) {
            if (this.fieldManager.isNavigableField(this.getFieldId())) {
                NavigableField navigableField = this.fieldManager.getNavigableField(this.getFieldId());
                if (this.getColumnLayout().contains(navigableField)) {
                    this.addError("fieldId", this.getText("admin.errors.column.already.exists", this.getText(navigableField.getNameKey())));
                    return "error";
                }
                this.getColumnLayout().addColumn(navigableField);
                this.store();
                return this.redirectToView();
            }
            if (this.fieldManager.getField(this.getFieldId()) != null) {
                this.addError("fieldId", this.getText("admin.errors.column.cannot.be.shown", this.getText(this.fieldManager.getField(this.getFieldId()).getNameKey())));
            } else {
                this.addError("fieldId", this.getText("admin.errors.column.does.not.exist", "'" + this.getFieldId() + "'"));
            }
            return "error";
        }
        this.addError("fieldId", this.getText("admin.errors.select.field"));
        return "input";
    }

    protected String redirectToView() {
        return this.getRedirect(this.getActionName() + "!default.jspa");
    }

    private String doDelete() throws Exception {
        if (this.getFieldPosition() != null) {
            List<ColumnLayoutItem> columnLayoutItems = this.getColumnLayout().getColumnLayoutItems();
            if (this.getFieldPosition() >= 0 && this.getFieldPosition() <= columnLayoutItems.size() - 1) {
                ColumnLayoutItem columnLayoutItem = columnLayoutItems.get(this.getFieldPosition());
                this.getColumnLayout().removeColumn(columnLayoutItem);
                this.store();
                return this.redirectToView();
            }
            this.addErrorMessage(this.getText("admin.errors.cannot.delete.field", "'" + (this.getFieldPosition() + 1) + "'"));
            return "error";
        }
        this.addErrorMessage(this.getText("admin.errors.select.column.to.delete"));
        return "input";
    }

    private String doMoveLeft() throws Exception {
        if (this.getFieldPosition() != null) {
            if (this.getFieldPosition() > 0) {
                ColumnLayoutItem columnLayoutItem = this.getColumnLayout().getColumnLayoutItems().get(this.getFieldPosition());
                this.getColumnLayout().moveColumnLeft(columnLayoutItem);
                this.store();
                this.setFieldId(columnLayoutItem.getNavigableField().getId());
                return this.redirectToView();
            }
            this.addErrorMessage(this.getText("admin.errors.cannot.move.column.left", "'" + (this.getFieldPosition() + 1) + "'"));
            return "error";
        }
        this.addErrorMessage(this.getText("admin.errors.select.column.to.move.left"));
        return "input";
    }

    private String doMoveRight() throws Exception {
        if (this.getFieldPosition() != null) {
            List<ColumnLayoutItem> columnLayoutItems = this.getColumnLayout().getColumnLayoutItems();
            if (this.getFieldPosition() < columnLayoutItems.size() - 1) {
                ColumnLayoutItem columnLayoutItem = columnLayoutItems.get(this.getFieldPosition());
                this.getColumnLayout().moveColumnRight(columnLayoutItem);
                this.store();
                this.setFieldId(columnLayoutItem.getNavigableField().getId());
                return this.redirectToView();
            }
            this.addErrorMessage(this.getText("admin.errors.cannot.move.column.right", "'" + (this.getFieldPosition() + 1) + "'"));
            return "error";
        }
        this.addErrorMessage(this.getText("admin.errors.select.column.to.move.right"));
        return "input";
    }

    public abstract String doShowActionsColumn() throws Exception;

    public abstract String doHideActionsColumn() throws Exception;

    protected abstract String doRestoreDefault();

    protected abstract void store();

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }

    private int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Integer getFieldPosition() {
        return this.fieldPosition;
    }

    public void setFieldPosition(Integer fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    public List getColumns() {
        return this.getColumnLayout().getColumnLayoutItems();
    }

    public abstract String getActionLocation(String var1);

    public List getAddableColumns() {
        if (this.addableColumns == null) {
            try {
                List<NavigableField> addableColumns = this.getAvailableNavigatableFields();
                List<ColumnLayoutItem> visibleColumnLayoutItems = this.getColumnLayout().getColumnLayoutItems();
                for (ColumnLayoutItem columnLayoutItem : visibleColumnLayoutItems) {
                    addableColumns.remove(columnLayoutItem.getNavigableField());
                }
                Iterator<NavigableField> iterator = addableColumns.iterator();
                while (iterator.hasNext()) {
                    CustomField customField;
                    NavigableField field = iterator.next();
                    if (!(field instanceof CustomField) || (customField = (CustomField)field).getCustomFieldType().getDescriptor().isViewTemplateExists() || customField.getCustomFieldType().getDescriptor().isColumnViewTemplateExists()) continue;
                    iterator.remove();
                }
                NameComparator nameComparator = new NameComparator(new I18nBean(this.getLoggedInUser()));
                Collections.sort(addableColumns, nameComparator);
                this.addableColumns = addableColumns;
            }
            catch (FieldException e) {
                this.log.error((Object)"Error while retrieving available navigatable fields.", (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.error.retrieving.navigatable.fields"));
                this.addableColumns = Collections.emptyList();
            }
        }
        return this.addableColumns;
    }

    protected abstract List<NavigableField> getAvailableNavigatableFields() throws FieldException;

    public List<Issue> getSampleIssues() {
        SearchRequest searchRequest = this.getSearchRequestFromSession();
        if (searchRequest == null) {
            searchRequest = new SearchRequest();
        }
        try {
            PagerFilter pagerFilter = new PagerFilter(5);
            List<Issue> searchResults = this.searchProvider.search(searchRequest.getQuery(), this.getLoggedInUser(), pagerFilter).getIssues();
            return new ArrayList<Issue>(searchResults);
        }
        catch (SearchException e) {
            this.log.error((Object)"Error retrieving sample issues for customisation of navigator columns.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private SearchRequest getSearchRequestFromSession() {
        SessionSearchRequestManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createSearchRequestManager();
        return (SearchRequest)sessionSearchRequestManager.getCurrentObject();
    }

    public PagerFilter getPager() {
        return new PagerFilter(5);
    }

    @Override
    public boolean isFieldHidden(Long projectId, String id, String issueTypeId) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null.");
        }
        try {
            Project project = ManagerFactory.getProjectManager().getProjectObj(projectId);
            FieldManager fieldManager = ManagerFactory.getFieldManager();
            FieldLayout fieldLayout = fieldManager.getFieldLayoutManager().getFieldLayout(project, issueTypeId);
            return fieldLayout.isFieldHidden(id);
        }
        catch (DataAccessException e) {
            this.log.error((Object)"Cannot retrieve field layout.", (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.cannot.retrieve.field.layout"));
            return true;
        }
    }

    protected abstract EditableColumnLayout getColumnLayout();

    protected ColumnLayoutManager getColumnLayoutManager() {
        return this.getFieldManager().getColumnLayoutManager();
    }
}

