/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.vcs.cvsimpl;

import alt.java.io.FileImpl;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.LockException;
import com.atlassian.jira.vcs.AbstractRepository;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryException;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.vcs.viewcvs.ViewCvsBrowser;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.statcvs.input.CommitListBuilder;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CvsRepository
extends AbstractRepository {
    private static final Logger log = Logger.getLogger(CvsRepository.class);
    private String cvsLogFilePath;
    private String cvsRoot;
    private String moduleName;
    private String password;
    private boolean fetchLog;
    private long cvsTimeout;
    private CvsContent content;
    public static final String KEY_BASEDIR = "cvsbasedir";
    public static final long CVS_OPERATION_TIMEOUT_DEFAULT = 600000L;
    public static final String KEY_LOG_FILE_PATH = "cvslogfilepath";
    public static final String KEY_CVS_ROOT = "cvsroot";
    public static final String KEY_MODULE_NAME = "cvsmodulename";
    public static final String KEY_PASSWORD = "cvspassword";
    public static final String KEY_FETCH_LOG = "cvsfetchlog";
    public static final String KEY_CVS_TIMEOUT = "cvstimeout";
    private alt.java.io.File tempFile;
    private final CvsRepositoryUtil cvsRepositoryUtil;

    public CvsRepository(PropertySet propertySet, CvsRepositoryUtil cvsRepositoryUtil) {
        super(propertySet);
        this.cvsRepositoryUtil = cvsRepositoryUtil;
        this.cvsLogFilePath = propertySet.getString(KEY_LOG_FILE_PATH);
        this.cvsRoot = propertySet.getString(KEY_CVS_ROOT);
        this.moduleName = propertySet.getString(KEY_MODULE_NAME);
        this.password = propertySet.getString(KEY_PASSWORD);
        this.fetchLog = Boolean.parseBoolean(propertySet.getString(KEY_FETCH_LOG));
        this.cvsTimeout = NumberUtils.toLong((String)propertySet.getString(KEY_CVS_TIMEOUT), (long)600000L);
        String repositoryBrowserType = propertySet.getString("repositorybrowsertype");
        if (TextUtils.stringSet((String)repositoryBrowserType) && "VIEW_CVS".equals(repositoryBrowserType)) {
            try {
                HashMap<String, String> browserParams = new HashMap<String, String>();
                browserParams.put("viewcvsrootparameter", propertySet.getString("viewcvsrootparameter"));
                this.setRepositoryBrowser(new ViewCvsBrowser(propertySet.getString("viewcvsbaseurl"), browserParams));
            }
            catch (MalformedURLException e) {
                log.error((Object)"Error while creating ViewCVS Repository Browser.", (Throwable)e);
            }
        }
    }

    public String getCvsLogFilePath() {
        return this.cvsLogFilePath;
    }

    public void setCvsLogFilePath(String cvsLogFilePath) {
        this.cvsLogFilePath = cvsLogFilePath;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public long getCvsTimeout() {
        return this.cvsTimeout;
    }

    public void setCvsTimeout(long cvsTimeout) {
        this.cvsTimeout = cvsTimeout;
    }

    public String getCvsTimeoutStringInSeconds() {
        return String.valueOf(TimeUnit.MILLISECONDS.toSeconds(this.cvsTimeout));
    }

    public boolean fetchLog() {
        return this.fetchLog;
    }

    public void setFetchLog(boolean fetchLog) {
        this.fetchLog = fetchLog;
    }

    private void parseCvsLogs(String filename) throws IOException, LogSyntaxException, LockException {
        this.content = this.cvsRepositoryUtil.parseCvsLogs((alt.java.io.File)new FileImpl(filename), this.moduleName, this.cvsRepositoryUtil.parseCvsRoot(this.cvsRoot).getRepository(), this.getName());
    }

    public synchronized String updateCvs() throws CommandException, AuthenticationException, IOException, LockException {
        if (this.fetchLog) {
            alt.java.io.File outputFile;
            if (this.cvsLogFilePath == null || this.cvsLogFilePath.length() <= 0) {
                if (this.tempFile == null) {
                    log.debug((Object)"No temp file found - creating one");
                    outputFile = new FileImpl(File.createTempFile("cvs-", ".log"));
                    outputFile.deleteOnExit();
                    this.tempFile = outputFile;
                } else {
                    log.debug((Object)"Found a temp file to use.");
                    outputFile = this.tempFile;
                }
                log.info((Object)("Repository has no log file path set - using temporary file '" + outputFile.getAbsolutePath() + "'."));
            } else {
                outputFile = new FileImpl(this.cvsLogFilePath);
            }
            this.cvsRepositoryUtil.updateCvs(outputFile, this.cvsRoot, this.moduleName, this.password, this.cvsTimeout);
            return outputFile.getAbsolutePath();
        }
        log.debug((Object)"Not fetching log as the option is disabled.");
        return this.cvsLogFilePath;
    }

    @Override
    public List<Commit> getCommitsForIssue(final String issueKey) throws RepositoryException {
        log.debug((Object)"Starting commit matching.");
        long t0 = System.currentTimeMillis();
        if (this.content == null) {
            return null;
        }
        CommitListBuilder commitListBuilder = new CommitListBuilder(this.content.getRevisions()){

            protected void processRevision(CvsRevision rev) {
                if (JiraKeyUtils.isKeyInString(issueKey, rev.getComment())) {
                    super.processRevision(rev);
                }
            }
        };
        List matchingCommits = commitListBuilder.createCommitList();
        ArrayList<Commit> cvsCommits = new ArrayList<Commit>(matchingCommits);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Finished commit matching.");
            log.debug((Object)("Matching took " + (System.currentTimeMillis() - t0) + "ms and matched " + cvsCommits.size() + " commits."));
        }
        return cvsCommits;
    }

    public synchronized void updateRepository() throws CommandException, AuthenticationException, IOException, LockException, LogSyntaxException {
        String cvsLog = this.updateCvs();
        this.parseCvsLogs(cvsLog);
    }

    @Override
    public String getType() {
        return "cvs";
    }

    @Override
    public String toString() {
        return super.toString() + ",cvsLogFilePath=" + this.cvsLogFilePath + ",cvsRoot=" + this.cvsRoot + ",moduleName=" + this.moduleName + ",password=" + this.password + ", fetchLog=" + this.fetchLog;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CvsRepository)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CvsRepository cvsRepository = (CvsRepository)o;
        if (this.fetchLog != cvsRepository.fetchLog) {
            return false;
        }
        if (this.cvsLogFilePath != null ? !this.cvsLogFilePath.equals(cvsRepository.cvsLogFilePath) : cvsRepository.cvsLogFilePath != null) {
            return false;
        }
        if (this.cvsRoot != null ? !this.cvsRoot.equals(cvsRepository.cvsRoot) : cvsRepository.cvsRoot != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(cvsRepository.moduleName) : cvsRepository.moduleName != null) {
            return false;
        }
        return !(this.password != null ? !this.password.equals(cvsRepository.password) : cvsRepository.password != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.cvsLogFilePath != null ? this.cvsLogFilePath.hashCode() : 0);
        result = 29 * result + (this.cvsRoot != null ? this.cvsRoot.hashCode() : 0);
        result = 29 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 29 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 29 * result + (this.fetchLog ? 1 : 0);
        return result;
    }

    @Override
    public void copyContent(Repository repository) {
        if (repository instanceof CvsRepository) {
            this.content = ((CvsRepository)repository).content;
        }
    }

    protected CvsContent getCvsContent() {
        return this.content;
    }
}

