/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.vcs;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.LockException;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryException;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CVSCommit;
import com.atlassian.jira.vcs.cvsimpl.CvsRepository;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.model.Commit;
import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultRepositoryManager
implements RepositoryManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultRepositoryManager.class);
    private final AssociationManager associationManager;
    private final ServiceManager serviceManager;
    private PermissionManager permissionManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final ProjectManager projectManager;
    private final EventPublisher eventPublisher;
    private final OfBizDelegator ofBizDelegator;
    private final Map<Long, Repository> repositories;

    public DefaultRepositoryManager(AssociationManager associationManager, OfBizDelegator ofBizDelegator, ServiceManager serviceManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, ProjectManager projectManager, EventPublisher eventPublisher) throws GenericEntityException {
        this.associationManager = associationManager;
        this.ofBizDelegator = ofBizDelegator;
        this.serviceManager = serviceManager;
        this.permissionManager = permissionManager;
        this.changeHistoryManager = changeHistoryManager;
        this.projectManager = projectManager;
        this.eventPublisher = eventPublisher;
        this.repositories = new HashMap<Long, Repository>();
        this.refresh();
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        try {
            this.refresh();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    private void loadRepositories() {
        List<GenericValue> vcsRepositories = this.ofBizDelegator.findAll("VersionControl");
        if (vcsRepositories == null) {
            return;
        }
        for (GenericValue vcsRepository : vcsRepositories) {
            if (vcsRepository == null) continue;
            this.getRepository(vcsRepository.getLong("id"));
        }
    }

    @Override
    public Collection<Repository> getRepositoriesForProject(GenericValue project) throws GenericEntityException {
        if (project == null) {
            throw new IllegalArgumentException("Tried to get repository for null project");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("getProviderForProject called with an entity of type '" + project.getEntityName() + "' - which is not a project");
        }
        List<GenericValue> vcsRepositories = this.getAssociationManager().getSinkFromSource(project, "VersionControl", "ProjectVersionControl", false);
        if (vcsRepositories == null) {
            return Collections.emptyList();
        }
        if (vcsRepositories.size() >= 1) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (GenericValue vcsRepository : vcsRepositories) {
                Repository repository = this.getRepository(vcsRepository.getLong("id"));
                repositories.add(repository);
            }
            return repositories;
        }
        log.debug((Object)("No repository defined for project '" + project.getString("name") + "'"));
        return Collections.emptyList();
    }

    @Override
    public Collection<GenericValue> getProjectsForRepository(Repository repository) throws GenericEntityException {
        if (repository == null) {
            throw new IllegalArgumentException("Tried to get projects for null repository");
        }
        GenericValue repositoryGV = this.getRepositoryGV(repository.getId());
        List<GenericValue> projectGVs = this.associationManager.getSourceFromSink(repositoryGV, "Project", "ProjectVersionControl", false);
        if (projectGVs == null || projectGVs.isEmpty()) {
            log.debug((Object)("No projects defined for repository '" + repository.getName() + "'."));
            return Collections.emptyList();
        }
        return projectGVs;
    }

    @Override
    public Repository getRepository(String name) {
        for (Repository repository : this.getRepositories()) {
            if (!(name == null ? repository.getName() == null : name.equals(repository.getName()))) continue;
            return repository;
        }
        return null;
    }

    @Override
    public Repository getRepository(Long id) {
        if (this.repositories.containsKey(id)) {
            return this.repositories.get(id);
        }
        GenericValue versionControlGV = this.getRepositoryGV(id);
        Repository repository = this.getRepository(versionControlGV);
        this.repositories.put(id, repository);
        return repository;
    }

    private GenericValue getRepositoryGV(Long id) {
        return EntityUtil.getOnly(this.ofBizDelegator.findByAnd("VersionControl", EasyMap.build((Object)"id", (Object)id)));
    }

    private Repository getRepository(GenericValue versionControlGV) {
        if ("cvs".equals(versionControlGV.getString("type"))) {
            PropertySet cvsPropertySet = this.getPropertySet(versionControlGV);
            CvsRepository cvsRepo = new CvsRepository(cvsPropertySet, ComponentManager.getInstance().getCvsRepositoryUtil());
            cvsRepo.setId(versionControlGV.getLong("id"));
            cvsRepo.setName(versionControlGV.getString("name"));
            cvsRepo.setDescription(versionControlGV.getString("description"));
            return cvsRepo;
        }
        throw new IllegalArgumentException("Unknown repository type '" + versionControlGV.getString("type") + "'");
    }

    @Override
    public PropertySet getPropertySet(GenericValue versionControlGV) {
        return OFBizPropertyUtils.getPropertySet(versionControlGV);
    }

    @Override
    public boolean isValidType(String type) {
        return VCS_TYPES.contains(type);
    }

    @Override
    public Map<Long, Set<CVSCommit>> getCommits(Issue issue, User remoteUser) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!this.permissionManager.hasPermission(29, issue, remoteUser)) {
            return Collections.emptyMap();
        }
        return this.getAllCommitsInAllIssueRepositories(issue);
    }

    private Map<Long, Set<CVSCommit>> getAllCommitsInAllIssueRepositories(Issue issue) {
        Collection<String> previousIssueKeys = this.changeHistoryManager.getPreviousIssueKeys(issue.getId());
        Set<Repository> repositories = this.getAllRepositories(issue, previousIssueKeys);
        LinkedHashSet<String> allIssueKeys = new LinkedHashSet<String>();
        allIssueKeys.addAll(previousIssueKeys);
        allIssueKeys.add(issue.getKey());
        HashMap<Long, Set<CVSCommit>> repositoryCommits = new HashMap<Long, Set<CVSCommit>>();
        for (Repository repository : repositories) {
            for (String issueKey : allIssueKeys) {
                this.mapCommitsToRepository(repository, issueKey, repositoryCommits);
            }
        }
        return repositoryCommits;
    }

    private Set<Repository> getAllRepositories(Issue issue, Collection<String> previousIssueKeys) {
        HashSet<Repository> repositories = new HashSet<Repository>();
        try {
            repositories.addAll(this.getRepositoriesForProject(issue.getProject()));
            for (String issueKey : previousIssueKeys) {
                Collection<Repository> repos;
                String projectKey = JiraKeyUtils.getProjectKeyFromIssueKey(issueKey);
                Project project = this.projectManager.getProjectObjByKey(projectKey);
                if (project == null || (repos = this.getRepositoriesForProject(project.getGenericValue())) == null) continue;
                repositories.addAll(repos);
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error retrieving project repositories", (Throwable)e);
        }
        return repositories;
    }

    private void mapCommitsToRepository(Repository repository, String issueKey, Map<Long, Set<CVSCommit>> repositoryCommits) {
        try {
            List<Commit> coms = repository.getCommitsForIssue(issueKey);
            this.mergeCommitsForRepository(repositoryCommits, repository, coms);
        }
        catch (RepositoryException e) {
            log.error((Object)"Error while retrieving commits from the repository", (Throwable)e);
        }
    }

    private void mergeCommitsForRepository(Map<Long, Set<CVSCommit>> repositoryCommits, Repository repository, List<Commit> coms) {
        Long repositoryId = repository.getId();
        if (!repositoryCommits.containsKey(repositoryId) || repositoryCommits.get(repositoryId) == null) {
            repositoryCommits.put(repositoryId, this.transformCommits(repository, coms));
        } else {
            Collection commits = repositoryCommits.get(repositoryId);
            Set<CVSCommit> cvsCommits = this.transformCommits(repository, coms);
            if (cvsCommits != null) {
                commits.addAll(cvsCommits);
            }
        }
    }

    private Set<CVSCommit> transformCommits(Repository repository, List<Commit> coms) {
        if (coms == null) {
            return null;
        }
        HashSet<CVSCommit> commits = new HashSet<CVSCommit>();
        for (Commit com : coms) {
            commits.add(new CVSCommit(com, repository));
        }
        return commits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository createRepository(String type, String name, String description, Properties properties) throws Exception {
        if ("cvs".equals(type)) {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("type", type);
            fields.put("name", name);
            fields.put("description", description);
            GenericValue repositoryRecord = EntityUtils.createValue("VersionControl", fields);
            PropertySet propertySet = OFBizPropertyUtils.getPropertySet(repositoryRecord);
            this.persistProperties(properties, propertySet);
            Map<Long, Repository> map = this.repositories;
            synchronized (map) {
                if (this.repositories.isEmpty()) {
                    this.createRepositoryUpdateService();
                }
                return this.getRepository(repositoryRecord.getLong("id"));
            }
        }
        throw new IllegalArgumentException("Unhandled VCS provider type " + type);
    }

    private void persistProperties(Properties properties, PropertySet propertySet) {
        for (Object o : properties.keySet()) {
            String key = (String)o;
            propertySet.setString(key, properties.getProperty(key));
        }
    }

    private void createRepositoryUpdateService() throws Exception {
        this.serviceManager.addService("VCS Update Service", "com.atlassian.jira.service.services.vcs.VcsService", 3600000L);
    }

    private void removeRepositoryUpdateService() throws Exception {
        this.getServiceManager().removeServiceByName("VCS Update Service");
    }

    @Override
    public void updateRepository(Long id, String type, String name, String description, Properties properties) throws GenericEntityException {
        if (!"cvs".equals(type)) {
            throw new IllegalArgumentException("Unhandled VCS provider type " + type);
        }
        GenericValue versionControlGV = this.getVersionControlGV(id);
        PropertySet cvsPropertySet = OFBizPropertyUtils.getPropertySet(versionControlGV);
        boolean isDiffrentRepository = this.isDifferentRepository(cvsPropertySet, properties);
        Repository oldRepository = this.getRepository(id);
        if (this.repositories.containsKey(id)) {
            this.repositories.remove(id);
        }
        versionControlGV.set("type", (Object)type);
        versionControlGV.set("name", (Object)name);
        versionControlGV.set("description", (Object)description);
        versionControlGV.store();
        this.persistProperties(properties, cvsPropertySet);
        LinkedList keys = new LinkedList(cvsPropertySet.getKeys());
        keys.removeAll(keys);
        for (String key : keys) {
            cvsPropertySet.remove(key);
        }
        Repository repository = this.getRepository(id);
        if (!isDiffrentRepository) {
            repository.copyContent(oldRepository);
        }
        if (isDiffrentRepository) {
            this.markVcsServiceToRun();
        }
    }

    private GenericValue getVersionControlGV(Long id) throws GenericEntityException {
        GenericValue versionControlGV = this.getRepositoryGV(id);
        if (versionControlGV == null) {
            throw new GenericEntityException("Could not find VersionControl with id '" + id + "'.");
        }
        return versionControlGV;
    }

    protected boolean isDifferentRepository(PropertySet oldPropertySet, Properties newProperties) {
        return !DefaultRepositoryManager.equals("cvsmodulename", oldPropertySet, newProperties) || !DefaultRepositoryManager.equals("cvspassword", oldPropertySet, newProperties) || !DefaultRepositoryManager.equals("cvsroot", oldPropertySet, newProperties) || !DefaultRepositoryManager.equals("cvsfetchlog", oldPropertySet, newProperties);
    }

    protected static boolean equals(String propertyName, PropertySet oldPropertySet, Properties newProperties) {
        return ObjectUtils.equalsNullSafe(oldPropertySet.getString(propertyName), newProperties.getProperty(propertyName));
    }

    protected void markVcsServiceToRun() {
        JiraServiceContainer service;
        try {
            service = this.serviceManager.getServiceWithName("VCS Update Service");
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get the service with 'VCS Update Service' name");
            return;
        }
        if (service != null && service.isUsable()) {
            this.serviceManager.getScheduleSkipper().addService(service.getId());
            log.debug((Object)"VCS Update Service marked for execution at the next service run.");
        }
    }

    @Override
    public void removeRepository(Long id) throws Exception {
        GenericValue versionControlGV = this.getRepositoryGV(id);
        OFBizPropertyUtils.removePropertySet(versionControlGV);
        versionControlGV.remove();
        this.repositories.remove(id);
        if (this.repositories.isEmpty()) {
            this.removeRepositoryUpdateService();
        }
    }

    @Override
    public void setProjectRepositories(GenericValue project, Collection<Long> repositoryIds) throws GenericEntityException {
        ArrayList<GenericValue> newRepositories = new ArrayList<GenericValue>();
        for (Long repositoryId : repositoryIds) {
            GenericValue vcEntityList = this.getRepositoryGV(repositoryId);
            if (vcEntityList == null) {
                throw new GenericEntityException("Could not set project's repository; no VersionControl record with id '" + repositoryId + "'");
            }
            newRepositories.add(vcEntityList);
        }
        this.setProjectRepositories(project, (List<GenericValue>)newRepositories);
    }

    private void setProjectRepositories(GenericValue project, List<GenericValue> newRepositoryGVs) throws GenericEntityException {
        List<GenericValue> oldAssociations = this.associationManager.getSinkFromSource(project, "VersionControl", "ProjectVersionControl", false);
        for (GenericValue oldAssociation : oldAssociations) {
            this.associationManager.removeAssociation(project, oldAssociation, "ProjectVersionControl");
        }
        for (GenericValue repoEntity : newRepositoryGVs) {
            this.associationManager.createAssociation(project, repoEntity, "ProjectVersionControl");
        }
    }

    @Override
    public Collection<Repository> getRepositories() {
        return this.repositories.values();
    }

    @Override
    public boolean updateRepositories() throws GenericEntityException {
        boolean exception = true;
        Collection<Repository> repositories = this.getRepositories();
        for (Repository repository : repositories) {
            try {
                this.updateRepository(repository);
            }
            catch (CommandException e) {
                log.error((Object)("Error occurred while updating repository '" + repository.getName() + "': " + e.getMessage()), (Throwable)e);
                exception = false;
            }
            catch (AuthenticationException e) {
                log.error((Object)("Error occurred while updating repository '" + repository.getName() + "': " + e.getMessage()), (Throwable)e);
                Throwable cause = e.getUnderlyingThrowable();
                if (cause != null) {
                    log.error((Object)("Caused by: " + cause.getMessage()), cause);
                }
                exception = false;
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while updating repository '" + repository.getName() + "': " + e.getMessage()), (Throwable)e);
                exception = false;
            }
            catch (LogSyntaxException e) {
                log.error((Object)("Error occurred while updating repository '" + repository.getName() + "': " + e.getMessage()), (Throwable)e);
                exception = false;
            }
            catch (LockException e) {
                log.error((Object)("Error occurred while updating repository '" + repository.getName() + "': " + e.getMessage()), (Throwable)e);
                exception = false;
            }
        }
        return exception;
    }

    protected boolean updateRepository(Repository repository) throws CommandException, AuthenticationException, IOException, LogSyntaxException, LockException {
        if ("cvs".equals(repository.getType())) {
            try {
                if (!this.getProjectsForRepository(repository).isEmpty()) {
                    log.debug((Object)("Updating repository '" + repository.getName() + "'..."));
                    CvsRepository cvsRepository = (CvsRepository)repository;
                    cvsRepository.updateRepository();
                    log.debug((Object)("Finished updating repository '" + repository.getName() + "'."));
                    return true;
                }
                log.debug((Object)("No projects are associated with repository '" + repository.getName() + "' - not updating."));
            }
            catch (GenericEntityException e) {
                log.error((Object)("Error occurred while retrieving projects for repository '" + repository.getName() + "' - not updating."));
            }
        } else {
            log.debug((Object)("Repository '" + repository.getName() + "' is not CVS repository - not updating."));
        }
        return false;
    }

    @Override
    public void refresh() throws GenericEntityException {
        this.repositories.clear();
        this.loadRepositories();
    }

    protected AssociationManager getAssociationManager() {
        return this.associationManager;
    }

    protected ServiceManager getServiceManager() {
        return this.serviceManager;
    }
}

