/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.velocity;

import com.atlassian.jira.util.velocity.VelocityRequestSession;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpSessionBackedVelocityRequestSession
implements VelocityRequestSession {
    private final HttpServletRequest request;

    public HttpSessionBackedVelocityRequestSession(HttpServletRequest request) {
        this.request = request;
    }

    private HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    @Override
    public String getId() {
        HttpSession curSession = this.getSession(true);
        if (curSession == null) {
            return null;
        }
        return curSession.getId();
    }

    @Override
    public Object getAttribute(String s) {
        HttpSession curSession = this.getSession(false);
        return curSession == null ? null : curSession.getAttribute(s);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        HttpSession curSession = this.getSession(false);
        return curSession == null ? Collections.enumeration(Collections.emptyList()) : curSession.getAttributeNames();
    }

    @Override
    public void setAttribute(String s, Object o) {
        HttpSession curSession = this.getSession(true);
        curSession.setAttribute(s, o);
    }

    @Override
    public void removeAttribute(String s) {
        HttpSession curSession = this.getSession(false);
        if (curSession != null) {
            curSession.removeAttribute(s);
        }
    }

    @Override
    public void invalidate() {
        HttpSession curSession = this.getSession(false);
        if (curSession != null) {
            curSession.invalidate();
        }
    }
}

