/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.velocity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.HttpSessionBackedVelocityRequestSession;
import com.atlassian.jira.util.velocity.RequestContextParameterHolderImpl;
import com.atlassian.jira.util.velocity.SimpleVelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DefaultVelocityRequestContextFactory
implements VelocityRequestContextFactory {
    private final ApplicationProperties applicationProperties;

    public DefaultVelocityRequestContextFactory(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public DefaultVelocityRequestContextFactory() {
        this(ComponentAccessor.getApplicationProperties());
    }

    @Override
    public VelocityRequestContext getJiraVelocityRequestContext() {
        VelocityRequestContext cachedRequestContext = (VelocityRequestContext)JiraAuthenticationContextImpl.getRequestCache().get("jira.velocity.request.context");
        if (cachedRequestContext != null) {
            return cachedRequestContext;
        }
        return new SimpleVelocityRequestContext(this.applicationProperties.getString("jira.baseurl"));
    }

    @Override
    public Map<String, Object> getDefaultVelocityParams(Map<String, Object> startingParams, JiraAuthenticationContext authenticationContext) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, authenticationContext);
    }

    public static void cacheVelocityRequestContext(HttpServletRequest request) {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(request.getContextPath(), request);
    }

    @Override
    public void setVelocityRequestContext(HttpServletRequest request) {
        this.setVelocityRequestContext(request.getContextPath(), request);
    }

    public static void cacheVelocityRequestContext(String baseUrl, HttpServletRequest request) {
        RequestContextParameterHolderImpl requestContextParameterHolder = null;
        String canonicalBaseURL = baseUrl;
        HttpSessionBackedVelocityRequestSession session = null;
        if (request != null) {
            requestContextParameterHolder = new RequestContextParameterHolderImpl(request);
            canonicalBaseURL = JiraUrl.constructBaseUrl(request);
            session = new HttpSessionBackedVelocityRequestSession(request);
        }
        SimpleVelocityRequestContext velocityRequestContext = new SimpleVelocityRequestContext(baseUrl, canonicalBaseURL, requestContextParameterHolder, session);
        JiraAuthenticationContextImpl.getRequestCache().put("jira.velocity.request.context", velocityRequestContext);
    }

    @Override
    public void setVelocityRequestContext(String baseUrl, HttpServletRequest request) {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(baseUrl, request);
    }

    @Override
    public void cacheVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        this.setVelocityRequestContext(velocityRequestContext);
    }

    @Override
    public void setVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        JiraAuthenticationContextImpl.getRequestCache().put("jira.velocity.request.context", velocityRequestContext);
    }

    @Override
    public void clearVelocityRequestContext() {
        JiraAuthenticationContextImpl.getRequestCache().remove("jira.velocity.request.context");
    }
}

