/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class VersionNumber
implements Comparable<VersionNumber> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private transient int hashCode;
    private static final String SEPARATOR = ".";

    public VersionNumber(String version) {
        this(version, "\\.");
    }

    public VersionNumber(String version, String splitterRegex) {
        String[] segments = version == null ? new String[]{} : version.split(splitterRegex);
        this.major = segments.length > 0 ? this.parse(segments[0]) : 0;
        this.minor = segments.length > 1 ? this.parse(segments[1]) : 0;
        this.micro = segments.length > 2 ? this.parse(segments[2]) : 0;
        this.qualifier = segments.length == 0 ? "" : this.getQualifier(segments[segments.length - 1]);
    }

    private int parse(String segment) {
        try {
            return segment.length() == 0 ? 0 : Integer.parseInt(this.getVersion(segment));
        }
        catch (NumberFormatException e) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < segment.length(); ++i) {
                char c = segment.charAt(i);
                if (!Character.isDigit(c)) continue;
                buffer.append(c);
            }
            return this.parse(buffer.toString());
        }
    }

    private String getVersion(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? segment : segment.substring(0, n);
    }

    private String getQualifier(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? "" : segment.substring(n + 1);
    }

    @Override
    public int compareTo(VersionNumber versionNumber) {
        if (this.major < versionNumber.major) {
            return -1;
        }
        if (this.major > versionNumber.major) {
            return 1;
        }
        if (this.minor < versionNumber.minor) {
            return -1;
        }
        if (this.minor > versionNumber.minor) {
            return 1;
        }
        if (this.micro < versionNumber.micro) {
            return -1;
        }
        if (this.micro > versionNumber.micro) {
            return 1;
        }
        return this.qualifier.compareTo(versionNumber.qualifier);
    }

    public boolean isGreaterThan(VersionNumber v) {
        return this.compareTo(v) > 0;
    }

    public boolean isGreaterThanOrEquals(VersionNumber v) {
        return this.compareTo(v) >= 0;
    }

    public boolean isLessThan(VersionNumber v) {
        return this.compareTo(v) < 0;
    }

    public boolean isLessThanOrEquals(VersionNumber v) {
        return this.compareTo(v) <= 0;
    }

    public String getOSGIVersion() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.major).append(SEPARATOR).append(this.minor).append(SEPARATOR).append(this.micro);
        if (StringUtils.isNotEmpty((String)this.qualifier)) {
            ret.append(SEPARATOR).append(this.qualifier);
        }
        return ret.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof VersionNumber)) {
            return false;
        }
        return this.compareTo((VersionNumber)that) == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(this.major);
            builder.append(this.minor);
            builder.append(this.micro);
            builder.append((Object)this.qualifier);
            this.hashCode = builder.toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(this.major));
        sb.append(SEPARATOR).append(Integer.toString(this.minor));
        if (this.micro > 0) {
            sb.append(SEPARATOR).append(Integer.toString(this.micro));
        }
        if (this.qualifier.length() > 0) {
            sb.append("-").append(this.qualifier);
        }
        return sb.toString();
    }
}

