/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;

public class CompositeIndexLifecycleManager
implements IndexLifecycleManager {
    private static final Logger log = Logger.getLogger(CompositeIndexLifecycleManager.class);
    private final IndexLifecycleManager[] delegates;

    public CompositeIndexLifecycleManager(IssueIndexManager issueIndexManager, SharedEntityIndexManager sharedEntityIndexManager) {
        this.delegates = new IndexLifecycleManager[]{issueIndexManager, sharedEntityIndexManager};
    }

    @Override
    public long optimize() {
        log.info((Object)"Optimize Indexes starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long optimize = delegate.optimize();
            log.info((Object)("Optimize took: " + optimize + "ms. Indexer: " + delegate.toString()));
            result += optimize;
        }
        log.info((Object)("Optimize Indexes complete. Total time: " + result + "ms."));
        return result;
    }

    @Override
    public long reIndexAll(Context context) {
        log.info((Object)"Reindex All starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long reIndexAll = delegate.reIndexAll(context);
            log.info((Object)("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString()));
            result += reIndexAll;
        }
        context.setName("");
        log.info((Object)("Reindex All complete. Total time: " + result + "ms."));
        return result;
    }

    @Override
    public void shutdown() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.shutdown();
        }
    }

    @Override
    public long activate(Context context) {
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.activate(context);
        }
        return result;
    }

    @Override
    public void deactivate() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.deactivate();
        }
    }

    @Override
    public boolean isIndexingEnabled() {
        return this.delegates[0].isIndexingEnabled();
    }

    @Override
    public Collection<String> getAllIndexPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexLifecycleManager delegate : this.delegates) {
            result.addAll(delegate.getAllIndexPaths());
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public int size() {
        int result = 0;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.size();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

