/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class BlockingCounter {
    private final Sync sync;

    public BlockingCounter() {
        this.sync = new Sync(0);
    }

    public BlockingCounter(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        this.sync = new Sync(count);
    }

    public void up() {
        this.sync.acquireShared(1);
    }

    public void down() {
        this.sync.releaseShared(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(0, unit.toNanos(timeout));
    }

    public void await() throws InterruptedException {
        this.sync.acquireShared(0);
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return String.format("Blocking Counter [%d]", this.getCount());
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int WAITER = 0;
        private static final int COUNTER = 1;

        private Sync(int count) {
            this.setState(count);
        }

        @Override
        protected int tryAcquireShared(int arg) {
            if (arg == 0) {
                return this.getState() == 0 ? 1 : -1;
            }
            if (arg == 1) {
                int count;
                while (!this.compareAndSetState(count = this.getState(), count + 1)) {
                }
                return 1;
            }
            throw new AssertionError((Object)"This code should never be reached.");
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            if (arg == 1) {
                int nextCount;
                int count;
                do {
                    if ((count = this.getState()) != 0) continue;
                    throw new IllegalStateException("Trying to set counter below zero.");
                } while (!this.compareAndSetState(count, nextCount = count - 1));
                return nextCount == 0;
            }
            throw new AssertionError((Object)"This code should never be called.");
        }

        public int getCount() {
            return this.getState();
        }
    }
}

