/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class IdentitySet<T>
extends AbstractSet<T>
implements Set<T> {
    private final Set<IdentityReference<T>> delegateSet;

    public IdentitySet(Set<IdentityReference<T>> delegateSet) {
        this.delegateSet = Assertions.notNull("delegateSet", delegateSet);
    }

    public static <T> IdentitySet<T> newSet() {
        return new IdentitySet<T>(new HashSet<IdentityReference<T>>());
    }

    public static <T> IdentitySet<T> newListOrderedSet() {
        return new IdentitySet<T>(new LinkedHashSet<IdentityReference<T>>());
    }

    @Override
    public void clear() {
        this.delegateSet.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return new IdentityIterator<T>(this.delegateSet.iterator());
    }

    @Override
    public boolean add(T t) {
        return this.delegateSet.add(new IdentityReference<T>(t));
    }

    @Override
    public boolean remove(Object o) {
        return this.delegateSet.remove(new IdentityReference<Object>(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegateSet.containsAll(IdentitySet.convert(c));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegateSet.addAll(IdentitySet.convert(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegateSet.retainAll(IdentitySet.convert(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegateSet.removeAll(IdentitySet.convert(c));
    }

    @Override
    public int size() {
        return this.delegateSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegateSet.contains(new IdentityReference<Object>(o));
    }

    @Override
    public String toString() {
        return this.delegateSet.toString();
    }

    private static <C> Collection<IdentityReference<C>> convert(Collection<? extends C> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (collection.size() == 1) {
            return Collections.singletonList(new IdentityReference<C>(collection.iterator().next()));
        }
        ArrayList<IdentityReference<C>> list = new ArrayList<IdentityReference<C>>(collection.size());
        for (C c : collection) {
            list.add(new IdentityReference<C>(c));
        }
        return list;
    }

    public static final class IdentityReference<T> {
        private final T value;

        public IdentityReference(T value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityReference that = (IdentityReference)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static <T> IdentityReference<T> wrap(T value) {
            return new IdentityReference<T>(value);
        }
    }

    private static class IdentityIterator<T>
    implements Iterator<T> {
        private final Iterator<IdentityReference<T>> delegateIterator;

        public IdentityIterator(Iterator<IdentityReference<T>> delegateIterator) {
            this.delegateIterator = delegateIterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegateIterator.hasNext();
        }

        @Override
        public T next() {
            return this.delegateIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.delegateIterator.remove();
        }
    }
}

