/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.cache;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public final class ManagedCache<K, V> {
    private final ConcurrentMap<Object, Reference<V>> map = new ConcurrentHashMap<Object, Reference<V>>();
    private final Function<K, V> factory;
    private final Function<K, ?> keyFactory;

    public static <K, V, T> ManagedCache<K, V> newManagedCache(Function<K, V> factory, Function<K, T> keyFactory) {
        return new ManagedCache<K, V>(factory, keyFactory);
    }

    public static <K, V> ManagedCache<K, V> newManagedCache(Function<K, V> factory) {
        return new ManagedCache<K, V>(factory, Functions.identity());
    }

    private <T> ManagedCache(Function<K, V> factory, Function<K, T> keyFactory) {
        this.factory = factory;
        this.keyFactory = keyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K arg) {
        Object key = this.argToKey(arg);
        Reference ref = (Reference)this.map.get(key);
        while (ref == null) {
            this.map.putIfAbsent(key, (Reference<LazyRef>)((Object)new LazyRef(arg)));
            ref = (Reference)this.map.get(key);
        }
        V result = null;
        try {
            result = (V)ref.get();
        }
        finally {
            if (result == null) {
                this.map.remove(key, ref);
            }
        }
        return result;
    }

    private Object argToKey(K arg) {
        Assertions.notNull("arg", arg);
        Object key = this.keyFactory.apply(arg);
        Assertions.notNull("key", key);
        return key;
    }

    public void remove(K a) {
        this.map.remove(this.argToKey(a));
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    private class LazyRef
    extends LazyReference<V> {
        final AtomicReference<K> argRef;

        LazyRef(K arg) {
            this.argRef = new AtomicReference(arg);
        }

        protected V create() throws Exception {
            return ManagedCache.this.factory.apply(this.argRef.getAndSet(null));
        }
    }
}

