/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.FileFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class FileSystemFileFactory
implements FileFactory {
    private static final Logger log = Logger.getLogger(FileSystemFileFactory.class);

    @Override
    public File getFile(String absoluteFilename) {
        return new File(absoluteFilename);
    }

    @Override
    public void removeDirectoryIfExists(String directoryName) {
        File file = this.getFile(directoryName);
        if (file.exists()) {
            this.removeDirectory(file);
        }
    }

    @Override
    public void removeDirectory(File directory) {
        String[] list = directory.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String filename : list) {
            File f = this.getFile(directory.getAbsolutePath() + System.getProperty("file.separator") + filename);
            if (f.isDirectory()) {
                this.removeDirectory(f);
                continue;
            }
            log.debug((Object)("Deleting " + f.getAbsolutePath()));
            if (f.delete()) continue;
            log.warn((Object)("Unable to delete file " + f.getAbsolutePath()));
        }
        if (!directory.delete()) {
            log.error((Object)("Unable to delete directory " + directory.getAbsolutePath()));
        }
    }
}

