/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.EmailFormatter;
import com.opensymphony.util.TextUtils;

public class EmailFormatterImpl
implements EmailFormatter {
    private final ApplicationProperties applicationProperties;
    private static final String SYMBOL_AT = "@";
    private static final String SYMBOL_DOT = ".";
    private static final String TEXT_AT = " at ";
    private static final String TEXT_DOT = " dot ";
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";

    public EmailFormatterImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public boolean emailVisible(User user) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        return VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && user != null;
    }

    @Override
    public String formatEmail(User user, User currentUser) {
        if (user != null) {
            return this.formatEmail(user.getEmailAddress(), currentUser);
        }
        return null;
    }

    @Override
    public String formatEmail(String email, boolean isCurrentUserLoggedIn) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        if (!TextUtils.stringSet((String)emailVisibility)) {
            this.applicationProperties.setString("jira.option.emailvisible", VISIBILITY_PUBLIC);
            emailVisibility = VISIBILITY_PUBLIC;
        }
        if (VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && isCurrentUserLoggedIn) {
            return email;
        }
        if (VISIBILITY_MASKED.equals(emailVisibility)) {
            StringBuffer result = new StringBuffer(email);
            result = this.replacePattern(result, SYMBOL_AT, TEXT_AT);
            result = this.replacePattern(result, SYMBOL_DOT, TEXT_DOT);
            return result.toString();
        }
        return null;
    }

    @Override
    public String formatEmail(String email, User currentUser) {
        return this.formatEmail(email, currentUser != null);
    }

    @Override
    public String formatEmailAsLink(String email, User currentUser) {
        String emailVisibility = this.applicationProperties.getString("jira.option.emailvisible");
        if (VISIBILITY_PUBLIC.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && currentUser != null) {
            return "<a href=\"mailto:" + TextUtils.htmlEncode((String)email) + "\">" + TextUtils.htmlEncode((String)this.formatEmail(email, currentUser)) + "</a>";
        }
        return TextUtils.htmlEncode((String)this.formatEmail(email, currentUser));
    }

    private StringBuffer replacePattern(StringBuffer stringBuffer, String originalPattern, String newPattern) {
        if (stringBuffer == null || stringBuffer.length() < 1) {
            return null;
        }
        int index = stringBuffer.toString().indexOf(originalPattern);
        while (index != -1) {
            stringBuffer.replace(index, index + 1, newPattern);
            index = stringBuffer.toString().indexOf(originalPattern);
        }
        return stringBuffer;
    }
}

