/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;

public class DelegateComponentAdapter<T>
implements ComponentAdapter {
    private final Class<? super T> key;
    private final ComponentAdapter delegate;

    DelegateComponentAdapter(@NotNull Class<? super T> key, @NotNull ComponentAdapter delegate) {
        this.key = Assertions.notNull("key", key);
        this.delegate = Assertions.notNull("delegate", delegate);
    }

    public Class<? extends T> getComponentImplementation() {
        Class componentImplementation = this.delegate.getComponentImplementation();
        return componentImplementation;
    }

    public Class<? super T> getComponentKey() {
        return this.key;
    }

    public T getComponentInstance() throws PicoInitializationException, PicoIntrospectionException {
        Object componentInstance = this.delegate.getComponentInstance();
        return (T)componentInstance;
    }

    public PicoContainer getContainer() {
        return this.delegate.getContainer();
    }

    public void setContainer(PicoContainer picoContainer) {
        this.delegate.setContainer(picoContainer);
    }

    public void verify() throws PicoVerificationException {
        this.delegate.verify();
    }

    public static class Builder<T> {
        private final List<Class<? super T>> implementing = new ArrayList<Class<? super T>>();
        private final Class<T> concrete;

        public static <T> Builder<T> builderFor(@NotNull Class<T> concrete) {
            return new Builder<T>(concrete);
        }

        Builder(@NotNull Class<T> concrete) {
            this.concrete = Assertions.notNull("concrete", concrete);
        }

        public Builder<T> implementing(Class<? super T> interfaceClass) {
            this.implementing.add(interfaceClass);
            return this;
        }

        public void registerWith(MutablePicoContainer container) {
            Assertions.stateTrue("must implement some interfaces", !this.implementing.isEmpty());
            Iterator<Class<T>> interfaces = this.implementing.iterator();
            Class<? super T> registered = interfaces.next();
            container.registerComponentImplementation(registered, this.concrete);
            while (interfaces.hasNext()) {
                Class<? super T> alternate = interfaces.next();
                container.registerComponent(new DelegateComponentAdapter<T>(alternate, container.getComponentAdapter(registered)));
            }
        }
    }
}

