/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Shutdown;
import java.util.Arrays;
import java.util.Collections;
import org.apache.log4j.Logger;

public class CompositeShutdown
implements Shutdown {
    private final Logger log = Logger.getLogger(Shutdown.class);
    private final Iterable<Shutdown> list;

    public CompositeShutdown(Shutdown ... shutdowns) {
        this.list = Collections.unmodifiableList(Arrays.asList(shutdowns));
    }

    @Override
    public void shutdown() {
        for (Shutdown shutdown : this.list) {
            if (shutdown == null) continue;
            try {
                shutdown.shutdown();
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Cannot execute shutdown for: " + shutdown), (Throwable)e);
            }
        }
    }
}

