/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Sinks;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class CompositeCloseable
implements Closeable {
    private final Collection<Closeable> closeables;

    public CompositeCloseable(@NotNull Closeable closeable, @NotNull Closeable closeable2) {
        this(Arrays.asList(closeable, closeable2));
    }

    public CompositeCloseable(Collection<Closeable> closeables) {
        CollectionUtil.foreach(closeables, Sinks.nullChecker());
        this.closeables = Collections.unmodifiableCollection(closeables);
    }

    @Override
    public void close() {
        CollectionUtil.foreach(this.closeables, CLOSE);
    }
}

