/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class BuildUtils {
    private static final Logger log = Logger.getLogger(BuildUtils.class);
    private static final String BUILD_PARTNER_NAME = null;
    private static final Collection<Locale> UNAVAILABLE_LOCALES = Collections.emptyList();
    private static final String UNPARSED_DATE = "11-12-2011";
    private static final String BUILD_NUMBER = "710";
    private static final String VERSION = "5.0-aSourcesTest";
    private static final String SVN_REVISION = "167990";
    private static final String MINIMUM_UPGRADABLE_VERSION = "4.0";
    private static final String MINIMUM_UPGRADABLE_BUILD_NUMBER = "466";
    private static final Date PARSED_DATE;

    public static String getVersion() {
        return VERSION;
    }

    public static String getSvnRevision() {
        return SVN_REVISION;
    }

    public static String getCurrentBuildNumber() {
        return BUILD_NUMBER;
    }

    public static Date getCurrentBuildDate() {
        return PARSED_DATE;
    }

    public static String getBuildInformation() {
        StringBuffer sb = new StringBuffer();
        sb.append(BuildUtils.getVersion());
        sb.append("#");
        sb.append(BuildUtils.getCurrentBuildNumber());
        if (StringUtils.isNotBlank((String)BuildUtils.getSvnRevision())) {
            sb.append("-r");
            sb.append(BuildUtils.getSvnRevision());
        }
        if (BuildUtils.getBuildPartnerName() != null) {
            sb.append("-");
            sb.append(BuildUtils.getBuildPartnerName());
        }
        return sb.toString();
    }

    public static String getBuildPartnerName() {
        return BUILD_PARTNER_NAME;
    }

    public static Collection<Locale> getUnavailableLocales() {
        return UNAVAILABLE_LOCALES;
    }

    public static String getMinimumUpgradableVersion() {
        return MINIMUM_UPGRADABLE_VERSION;
    }

    public static String getMinimumUpgradableBuildNumber() {
        return MINIMUM_UPGRADABLE_BUILD_NUMBER;
    }

    static {
        Date parsedDate = null;
        try {
            parsedDate = new SimpleDateFormat("dd-MM-yyy", Locale.US).parse(UNPARSED_DATE);
        }
        catch (ParseException e) {
            log.fatal((Object)"Cannot Parse date: 11-12-2011.  Returning null for date");
        }
        PARSED_DATE = parsedDate;
    }
}

