/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.dbc.Assertions;

public class UserSharingPreferencesUtilImpl
implements UserSharingPreferencesUtil {
    private final PermissionManager permissionManager;
    private final UserPreferencesManager userPreferencesManager;

    public UserSharingPreferencesUtilImpl(PermissionManager permissionManager, UserPreferencesManager userPreferencesManager) {
        Assertions.notNull("permissionManager", permissionManager);
        Assertions.notNull("userPreferencesManager", userPreferencesManager);
        this.userPreferencesManager = userPreferencesManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public SharedEntity.SharePermissions getDefaultSharePermissions(User user) {
        Preferences userPreferences;
        SharedEntity.SharePermissions returnPermissions = SharedEntity.SharePermissions.PRIVATE;
        if (user != null && this.permissionManager.hasPermission(22, user) && !(userPreferences = this.userPreferencesManager.getPreferences(user)).getBoolean("user.default.share.private")) {
            returnPermissions = SharedEntity.SharePermissions.GLOBAL;
        }
        return returnPermissions;
    }
}

