/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.user.CachingExternalEntityStore;
import com.atlassian.jira.user.ExternalEntityStore;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultUserPropertyManager
implements UserPropertyManager,
Startable {
    protected final Map<String, PropertySet> psCache = new ConcurrentHashMap<String, PropertySet>();
    private static final String ENTITY_TYPE = "ExternalEntity";
    private final ExternalEntityStore externalEntityStore;
    private final EventPublisher eventPublisher;
    private final OfBizConnectionFactory ofBizConnectionFactory = new DefaultOfBizConnectionFactory();

    public DefaultUserPropertyManager(EventPublisher eventPublisher, ExternalEntityStore externalEntityStore) {
        this.eventPublisher = eventPublisher;
        this.externalEntityStore = externalEntityStore;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        ((CachingExternalEntityStore)ComponentManager.getComponentInstanceOfType(ExternalEntityStore.class)).onClearCache(null);
        this.psCache.clear();
    }

    @Override
    public PropertySet getPropertySet(User user) {
        Assertions.notNull("user", user);
        String name = user.getName();
        PropertySet cachedValue = this.psCache.get(name);
        if (cachedValue != null) {
            return cachedValue;
        }
        Long id = this.externalEntityStore.createIfDoesNotExist(name);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("entityId", id);
        args.put("entityName", ENTITY_TYPE);
        args.put("delegator.name", this.ofBizConnectionFactory.getDelegatorName());
        PropertySet basePs = PropertySetManager.getInstance((String)"ofbiz", args);
        args.clear();
        args.put("PropertySet", basePs);
        PropertySet ps = PropertySetManager.getInstance((String)"cached", args);
        this.psCache.put(name, ps);
        return ps;
    }
}

