/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;

public class DefaultUserProjectHistoryManager
implements UserProjectHistoryManager {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserHistoryManager userHistoryManager;

    public DefaultUserProjectHistoryManager(UserHistoryManager userHistoryManager, ProjectManager projectManager, PermissionManager permissionManager) {
        this.userHistoryManager = userHistoryManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public void addProjectToHistory(User user, Project project) {
        Assertions.notNull("project", project);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.PROJECT, user, project.getId().toString());
    }

    @Override
    public boolean hasProjectHistory(int permission, User user) {
        List<UserHistoryItem> history = this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(historyItem.getEntityId()));
                if (project == null || !this.permissionManager.hasPermission(permission, project, user)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Project getCurrentProject(int permission, User user) {
        List<UserHistoryItem> history = this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(historyItem.getEntityId()));
                if (project == null || !this.permissionManager.hasPermission(permission, project, user)) continue;
                return project;
            }
        }
        return null;
    }

    @Override
    public List<UserHistoryItem> getProjectHistoryWithoutPermissionChecks(User user) {
        return this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
    }

    @Override
    public List<Project> getProjectHistoryWithPermissionChecks(int permission, User user) {
        List<UserHistoryItem> history = this.getProjectHistoryWithoutPermissionChecks(user);
        ArrayList<Project> returnList = new ArrayList<Project>();
        if (history != null) {
            for (UserHistoryItem userHistoryItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(userHistoryItem.getEntityId()));
                if (project == null || !this.permissionManager.hasPermission(permission, project, user)) continue;
                returnList.add(project);
            }
        }
        return returnList;
    }

    @Override
    public List<Project> getProjectHistoryWithPermissionChecks(ProjectAction projectAction, User user) {
        List<UserHistoryItem> history = this.getProjectHistoryWithoutPermissionChecks(user);
        ArrayList<Project> returnList = new ArrayList<Project>();
        if (history != null) {
            for (UserHistoryItem userHistoryItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(userHistoryItem.getEntityId()));
                if (project == null || !projectAction.hasPermission(this.permissionManager, user, project)) continue;
                returnList.add(project);
            }
        }
        return returnList;
    }
}

