/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Nullable;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultUserHistoryManager
implements UserHistoryManager {
    private final UserHistoryStore store;

    public DefaultUserHistoryManager(@NotNull UserHistoryStore store) {
        this.store = Assertions.notNull("store", store);
    }

    @Override
    public void addItemToHistory(@NotNull UserHistoryItem.Type type, @NotNull User user, @NotNull String entityId) {
        this.addItemToHistory(type, user, entityId, null);
    }

    @Override
    public void addItemToHistory(@NotNull UserHistoryItem.Type type, @Nullable User user, @NotNull String entityId, @Nullable String data) {
        Assertions.notNull("type", type);
        Assertions.notNull("entityId", entityId);
        this.store.addHistoryItem(user, new UserHistoryItem(type, entityId, data));
    }

    @Override
    public boolean hasHistory(@NotNull UserHistoryItem.Type type, @NotNull User user) {
        Assertions.notNull("type", type);
        Assertions.notNull("user", user);
        List<UserHistoryItem> history = this.store.getHistory(type, user);
        return history != null && !history.isEmpty();
    }

    @Override
    @NotNull
    public List<UserHistoryItem> getHistory(@NotNull UserHistoryItem.Type type, @Nullable User user) {
        Assertions.notNull("type", type);
        return this.store.getHistory(type, user);
    }

    @Override
    public void removeHistoryForUser(@NotNull User user) {
        Assertions.notNull("user", user);
        this.store.removeHistoryForUser(user);
    }
}

