/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserGroupParameterCustomFieldClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(UserGroupParameterCustomFieldClauseXmlHandler.class);

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String originalXmlFieldId = el.getName();
        boolean forGroup = originalXmlFieldId.endsWith("_group");
        String xmlFieldId = forGroup ? originalXmlFieldId.substring(0, originalXmlFieldId.indexOf("_group")) : originalXmlFieldId;
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + originalXmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(originalXmlFieldId);
        }
        String value = el.getAttributeValue("groupName");
        if (StringUtils.isBlank((String)value)) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(originalXmlFieldId);
        }
        return new ClauseXmlHandler.FullConversionResult(this.createClause(clauseName, value));
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }

    Clause createClause(String jqlFieldName, String value) {
        return new TerminalClauseImpl(jqlFieldName, Operator.IN, new FunctionOperand("membersOf", value));
    }
}

