/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.AbstractSimpleClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextSystemFieldClauseXmlHandler
extends AbstractSimpleClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(TextSystemFieldClauseXmlHandler.class);
    private static final String FIELD = "field";
    private static final String QUERY = "query";
    private final Collection<String> supportedFields = CollectionBuilder.newBuilder(SystemSearchConstants.forSummary().getUrlParameter(), SystemSearchConstants.forDescription().getUrlParameter(), SystemSearchConstants.forComments().getUrlParameter(), SystemSearchConstants.forEnvironment().getUrlParameter()).asCollection();

    public TextSystemFieldClauseXmlHandler(FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        super(fieldFlagOperandRegistry);
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String elementName = el.getName();
        List<String> fields = this.getFields(el);
        String query = this.getQuery(el);
        if (query == null || fields.isEmpty()) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(elementName);
        }
        ArrayList<String> fieldsInError = new ArrayList<String>();
        HashMap<String, String> fieldsInBestGuess = new HashMap<String, String>();
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultOr();
        for (String field : fields) {
            String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(field);
            if (clauseName == null) {
                log.warn((Object)("Trying to generate a clause for field with id '" + field + "' and no corresponding clause name could be found."));
                fieldsInError.add(field);
                continue;
            }
            builder.addStringCondition(clauseName, Operator.LIKE, query).buildClause();
            if (this.xmlFieldIdSupported(field)) continue;
            fieldsInBestGuess.put(field, clauseName);
        }
        if (fieldsInError.size() == fields.size()) {
            return new ClauseXmlHandler.FailedConversionResult(elementName);
        }
        return new AggregatingConversionResult(builder.buildClause(), elementName, fieldsInError, fieldsInBestGuess);
    }

    @Override
    protected boolean xmlFieldIdSupported(String xmlFieldId) {
        return this.supportedFields.contains(xmlFieldId);
    }

    private String getQuery(Element el) {
        Elements valueEls = el.getElements(QUERY);
        if (valueEls.size() != 1) {
            log.error((Object)"A saved filter for multi text searching does not contain only one 'query' element.");
            return null;
        }
        return valueEls.first().getTextString();
    }

    private List<String> getFields(Element el) {
        ArrayList<String> fields = new ArrayList<String>();
        Elements valueEls = el.getElements(FIELD);
        while (valueEls.hasMoreElements()) {
            Element valueEl = valueEls.next();
            if (StringUtils.isNotBlank((String)valueEl.getTextString())) {
                fields.add(valueEl.getTextString());
                continue;
            }
            log.warn((Object)"A saved filter parameter for multi text field searching contains a 'field' tag with no value.");
        }
        return fields;
    }

    static class AggregatingConversionResult
    extends ClauseXmlHandler.BestGuessConversionResult {
        private final Collection<ClauseXmlHandler.FailedConversionResult> failures = new ArrayList<ClauseXmlHandler.FailedConversionResult>();
        private final Collection<ClauseXmlHandler.BestGuessConversionResult> bestGuesses;

        public AggregatingConversionResult(Clause clause, String oldXmlFieldName, Collection<String> errorFieldNames, Map<String, String> bestGuessFieldNames) {
            super(clause, oldXmlFieldName, oldXmlFieldName);
            for (String string : errorFieldNames) {
                this.failures.add(new ClauseXmlHandler.FailedConversionResult(string));
            }
            this.bestGuesses = new ArrayList<ClauseXmlHandler.BestGuessConversionResult>();
            for (Map.Entry entry : bestGuessFieldNames.entrySet()) {
                this.bestGuesses.add(new ClauseXmlHandler.BestGuessConversionResult(clause, (String)entry.getKey(), (String)entry.getValue()));
            }
        }

        @Override
        public ClauseXmlHandler.ConversionResultType getResultType() {
            return this.failures.isEmpty() && this.bestGuesses.isEmpty() ? ClauseXmlHandler.ConversionResultType.FULL_CONVERSION : ClauseXmlHandler.ConversionResultType.BEST_GUESS_CONVERSION;
        }

        @Override
        public void setFieldManager(FieldManager fieldManager) {
            super.setFieldManager(fieldManager);
            for (ClauseXmlHandler.BestGuessConversionResult bestGuess : this.bestGuesses) {
                bestGuess.setFieldManager(fieldManager);
            }
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            StringBuilder sb = new StringBuilder();
            Iterator<ClauseXmlHandler.FailedConversionResult> failedConversionResultIterator = this.failures.iterator();
            while (failedConversionResultIterator.hasNext()) {
                ClauseXmlHandler.FailedConversionResult failedConversionResult = failedConversionResultIterator.next();
                sb.append(failedConversionResult.getMessage(i18nHelper, savedFilterName));
                if (!failedConversionResultIterator.hasNext() && this.bestGuesses.isEmpty()) continue;
                sb.append("\n");
            }
            Iterator<ClauseXmlHandler.BestGuessConversionResult> bestGuessConversionResultIterator = this.bestGuesses.iterator();
            while (bestGuessConversionResultIterator.hasNext()) {
                ClauseXmlHandler.BestGuessConversionResult bestGuessConversionResult = bestGuessConversionResultIterator.next();
                sb.append(bestGuessConversionResult.getMessage(i18nHelper, savedFilterName));
                if (!bestGuessConversionResultIterator.hasNext()) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

